/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductChannel;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.ProductChannelHelper;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductChannelResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductChannelResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/product-channel.properties"}, scope=ServiceScope.PROTOTYPE, service={NestedFieldSupport.class, ProductChannelResource.class})
public class ProductChannelResourceImpl
extends BaseProductChannelResourceImpl
implements NestedFieldSupport {
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private ProductChannelHelper _productChannelHelper;

    @Override
    public void deleteProductChannel(Long id) throws Exception {
        this._commerceChannelRelService.deleteCommerceChannelRel(id.longValue());
    }

    @Override
    public Page<ProductChannel> getProductByExternalReferenceCodeProductChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        return this._productChannelHelper.getProductChannelsPage(cpDefinition.getCPDefinitionId(), pagination);
    }

    @Override
    public ProductChannel getProductChannel(Long id) throws Exception {
        return this._productChannelHelper.toProductChannel(this._commerceChannelRelService.getCommerceChannelRel(id.longValue()));
    }

    @Override
    @NestedField(parentClass=Product.class, value="productChannels")
    public Page<ProductChannel> getProductIdProductChannelsPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        return this._productChannelHelper.getProductChannelsPage(cpDefinition.getCPDefinitionId(), pagination);
    }
}

