/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"dto.class.name=ProductTaxConfiguration"}, service={DTOConverter.class, ProductTaxConfigurationDTOConverter.class})
public class ProductTaxConfigurationDTOConverter
implements DTOConverter<CPDefinition, ProductTaxConfiguration> {
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return ProductTaxConfiguration.class.getSimpleName();
    }

    public ProductTaxConfiguration toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        final CPTaxCategory cpTaxCategory = cpDefinition.getCPTaxCategory();
        return new ProductTaxConfiguration(){
            {
                this.id = cpDefinition.getCPTaxCategoryId();
                this.taxable = !cpDefinition.isTaxExempt();
                this.taxCategory = ProductTaxConfigurationDTOConverter.this._getTaxCategory(cpTaxCategory, dtoConverterContext.getLocale());
            }
        };
    }

    private String _getTaxCategory(CPTaxCategory cpTaxCategory, Locale locale) {
        if (cpTaxCategory == null) {
            return null;
        }
        return cpTaxCategory.getName(locale);
    }
}

