/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	enabled = false,
	property = "dto.class.name=com.liferay.commerce.product.model.CPSpecificationOption",
	service = {DTOConverter.class, SpecificationDTOConverter.class}
)
public class SpecificationDTOConverter
	implements DTOConverter<CPSpecificationOption, Specification> {

	@Override
	public String getContentType() {
		return Specification.class.getSimpleName();
	}

	@Override
	public Specification toDTO(DTOConverterContext dtoConverterContext)
		throws Exception {

		CPSpecificationOption cpSpecificationOption =
			_cpSpecificationOptionService.getCPSpecificationOption(
				(Long)dtoConverterContext.getId());

		CPOptionCategory cpOptionCategory =
			cpSpecificationOption.getCPOptionCategory();

		Specification specification = new Specification() {
			{
				description = LanguageUtils.getLanguageIdMap(
					cpSpecificationOption.getDescriptionMap());
				facetable = cpSpecificationOption.isFacetable();
				id = cpSpecificationOption.getCPSpecificationOptionId();
				key = cpSpecificationOption.getKey();
				title = LanguageUtils.getLanguageIdMap(
					cpSpecificationOption.getTitleMap());
			}
		};

		if (cpOptionCategory != null) {
			specification.setOptionCategory(
				_optionCategoryDTOConverter.toDTO(
					new DefaultDTOConverterContext(
						cpOptionCategory.getCPOptionCategoryId(),
						dtoConverterContext.getLocale())));
		}

		return specification;
	}

	@Reference
	private CPSpecificationOptionService _cpSpecificationOptionService;

	@Reference
	private OptionCategoryDTOConverter _optionCategoryDTOConverter;

}