/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Alessio Antonio Rendina
 * @author Igor Beslic
 */
public class ProductConfigurationUtil {

	public static CPDefinitionInventory updateCPDefinitionInventory(
			CPDefinitionInventoryService cpDefinitionInventoryService,
			ProductConfiguration productConfiguration, long cpDefinitionId)
		throws PortalException {

		CPDefinitionInventory cpDefinitionInventory =
			cpDefinitionInventoryService.
				fetchCPDefinitionInventoryByCPDefinitionId(cpDefinitionId);

		return cpDefinitionInventoryService.updateCPDefinitionInventory(
			cpDefinitionInventory.getCPDefinitionInventoryId(),
			GetterUtil.get(
				productConfiguration.getInventoryEngine(),
				cpDefinitionInventory.getCPDefinitionInventoryEngine()),
			productConfiguration.getLowStockAction(),
			GetterUtil.get(
				productConfiguration.getDisplayAvailability(),
				cpDefinitionInventory.isDisplayAvailability()),
			GetterUtil.get(
				productConfiguration.getDisplayStockQuantity(),
				cpDefinitionInventory.isDisplayStockQuantity()),
			GetterUtil.get(
				productConfiguration.getMinStockQuantity(),
				cpDefinitionInventory.getMinStockQuantity()),
			GetterUtil.get(
				productConfiguration.getAllowBackOrder(),
				cpDefinitionInventory.isBackOrders()),
			GetterUtil.get(
				productConfiguration.getMinOrderQuantity(),
				cpDefinitionInventory.getMinOrderQuantity()),
			GetterUtil.get(
				productConfiguration.getMaxOrderQuantity(),
				cpDefinitionInventory.getMaxOrderQuantity()),
			_getAllowedOrderQuantities(
				cpDefinitionInventory, productConfiguration),
			GetterUtil.get(
				productConfiguration.getMultipleOrderQuantity(),
				cpDefinitionInventory.getMultipleOrderQuantity()));
	}

	private static String _getAllowedOrderQuantities(
		CPDefinitionInventory cpDefinitionInventory,
		ProductConfiguration productConfiguration) {

		if (productConfiguration.getAllowedOrderQuantities() != null) {
			return StringUtil.merge(
				productConfiguration.getAllowedOrderQuantities());
		}

		if (cpDefinitionInventory == null) {
			return null;
		}

		return cpDefinitionInventory.getAllowedOrderQuantities();
	}

}