/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuOption;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.TimeZone;

public class SkuUtil {
    public static CPInstance addOrUpdateCPInstance(CPInstanceService cpInstanceService, Sku sku, CPDefinition cpDefinition, ServiceContext serviceContext) throws PortalException {
        long replacementCProductId = 0L;
        String replacementCPInstanceUuid = null;
        if (GetterUtil.getBoolean((Object)sku.getDiscontinued())) {
            CPInstance discontinuedCPInstance = null;
            if (Validator.isNotNull((String)sku.getReplacementSkuExternalReferenceCode())) {
                discontinuedCPInstance = cpInstanceService.fetchByExternalReferenceCode(sku.getReplacementSkuExternalReferenceCode(), cpDefinition.getCompanyId());
            }
            long replacementSkuId = GetterUtil.getLong((Object)sku.getReplacementSkuId());
            if (discontinuedCPInstance == null && replacementSkuId > 0L) {
                discontinuedCPInstance = cpInstanceService.fetchCPInstance(replacementSkuId);
            }
            if (discontinuedCPInstance != null) {
                CPDefinition discontinuedCPDefinition = discontinuedCPInstance.getCPDefinition();
                replacementCProductId = discontinuedCPDefinition.getCProductId();
                replacementCPInstanceUuid = discontinuedCPInstance.getCPInstanceUuid();
            }
        }
        Calendar discontinuedCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (sku.getDiscontinuedDate() != null) {
            discontinuedCalendar = DateConfigUtil.convertDateToCalendar(sku.getDiscontinuedDate());
        }
        DateConfig discontinuedDateConfig = new DateConfig(discontinuedCalendar);
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (sku.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(sku.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (sku.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(sku.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        return cpInstanceService.addOrUpdateCPInstance(sku.getExternalReferenceCode(), cpDefinition.getCPDefinitionId(), cpDefinition.getGroupId(), sku.getSku(), sku.getGtin(), sku.getManufacturerPartNumber(), GetterUtil.get((Object)sku.getPurchasable(), (boolean)false), SkuUtil._getOptions(sku), GetterUtil.get((Object)sku.getWidth(), (double)0.0), GetterUtil.get((Object)sku.getHeight(), (double)0.0), GetterUtil.get((Object)sku.getDepth(), (double)0.0), GetterUtil.get((Object)sku.getWeight(), (double)0.0), (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)BigDecimal.ZERO), (BigDecimal)GetterUtil.get((Object)sku.getCost(), (Number)BigDecimal.ZERO), GetterUtil.get((Object)sku.getPublished(), (boolean)false), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)sku.getNeverExpire(), (boolean)false), sku.getUnspsc(), GetterUtil.get((Object)sku.getDiscontinued(), (boolean)false), replacementCPInstanceUuid, replacementCProductId, discontinuedDateConfig.getMonth(), discontinuedDateConfig.getDay(), discontinuedDateConfig.getYear(), serviceContext);
    }

    private static String _getOptions(Sku sku) {
        SkuOption[] skuOptions = sku.getSkuOptions();
        if (skuOptions == null) {
            return "";
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (SkuOption skuOption : skuOptions) {
            jsonArray.put(JSONUtil.put((String)"key", (Object)skuOption.getKey()).put("value", JSONUtil.put((Object)skuOption.getValue())));
        }
        return jsonArray.toString();
    }
}

