/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.pricing.exception.NoSuchPricingClassException;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassCPDefinitionRel;
import com.liferay.commerce.pricing.service.CommercePricingClassCPDefinitionRelService;
import com.liferay.commerce.pricing.service.CommercePricingClassService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroupProduct;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductGroupProductDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductGroupProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductGroupProductUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductGroupProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/product-group-product.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductGroupProductResource.class})
public class ProductGroupProductResourceImpl
extends BaseProductGroupProductResourceImpl {
    @Reference
    private CommercePricingClassCPDefinitionRelService _commercePricingClassCPDefinitionRelService;
    @Reference
    private CommercePricingClassService _commercePricingClassService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private ProductGroupProductDTOConverter _productGroupProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteProductGroupProduct(Long id) throws Exception {
        this._commercePricingClassCPDefinitionRelService.deleteCommercePricingClassCPDefinitionRel(id.longValue());
    }

    @Override
    public Page<ProductGroupProduct> getProductGroupByExternalReferenceCodeProductGroupProductsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CommercePricingClass commercePricingClass = this._commercePricingClassService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePricingClass == null) {
            throw new NoSuchPricingClassException("Unable to find Product Group with externalReferenceCode: " + externalReferenceCode);
        }
        List commercePricingClassCPDefinitionRels = this._commercePricingClassCPDefinitionRelService.getCommercePricingClassCPDefinitionRels(commercePricingClass.getCommercePricingClassId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePricingClassCPDefinitionRelService.getCommercePricingClassCPDefinitionRelsCount(commercePricingClass.getCommercePricingClassId());
        return Page.of(this._toProductGroupProducts(commercePricingClassCPDefinitionRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Page<ProductGroupProduct> getProductGroupIdProductGroupProductsPage(Long id, Pagination pagination) throws Exception {
        List commercePricingClassCPDefinitionRels = this._commercePricingClassCPDefinitionRelService.getCommercePricingClassCPDefinitionRels(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._commercePricingClassCPDefinitionRelService.getCommercePricingClassCPDefinitionRelsCount(id.longValue());
        return Page.of(this._toProductGroupProducts(commercePricingClassCPDefinitionRels), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public ProductGroupProduct postProductGroupByExternalReferenceCodeProductGroupProduct(String externalReferenceCode, ProductGroupProduct productGroupProduct) throws Exception {
        CommercePricingClass commercePricingClass = this._commercePricingClassService.fetchByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commercePricingClass == null) {
            throw new NoSuchPricingClassException("Unable to find Product Group with externalReferenceCode: " + externalReferenceCode);
        }
        CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = ProductGroupProductUtil.addCommercePricingClassCPDefinitionRel(this._cProductLocalService, this._commercePricingClassCPDefinitionRelService, productGroupProduct, commercePricingClass, this._serviceContextHelper);
        return this._toProductGroupProduct(commercePricingClassCPDefinitionRel.getCommercePricingClassCPDefinitionRelId());
    }

    @Override
    public ProductGroupProduct postProductGroupIdProductGroupProduct(Long id, ProductGroupProduct productGroupProduct) throws Exception {
        CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel = ProductGroupProductUtil.addCommercePricingClassCPDefinitionRel(this._cProductLocalService, this._commercePricingClassCPDefinitionRelService, productGroupProduct, this._commercePricingClassService.getCommercePricingClass(id.longValue()), this._serviceContextHelper);
        return this._toProductGroupProduct(commercePricingClassCPDefinitionRel.getCommercePricingClassCPDefinitionRelId());
    }

    private ProductGroupProduct _toProductGroupProduct(Long commercePricingClassCPDefinitionRelId) throws Exception {
        return this._productGroupProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)commercePricingClassCPDefinitionRelId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<ProductGroupProduct> _toProductGroupProducts(List<CommercePricingClassCPDefinitionRel> commercePricingClassCPDefinitionRels) throws Exception {
        ArrayList<ProductGroupProduct> productGroupProducts = new ArrayList<ProductGroupProduct>();
        for (CommercePricingClassCPDefinitionRel commercePricingClassCPDefinitionRel : commercePricingClassCPDefinitionRels) {
            productGroupProducts.add(this._toProductGroupProduct(commercePricingClassCPDefinitionRel.getCommercePricingClassCPDefinitionRelId()));
        }
        return productGroupProducts;
    }
}

