/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.exception.CPAttachmentFileEntryProtocolException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.AttachmentBase64;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.AttachmentUrl;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public class AttachmentUtil {
    private static final String _TEMP_FILE_NAME = AttachmentUtil.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AttachmentUtil.class);

    public static FileEntry addFileEntry(Attachment attachment, long groupId, long userId, UniqueFileNameProvider uniqueFileNameProvider) throws Exception {
        if (Validator.isNotNull((String)attachment.getAttachment())) {
            return AttachmentUtil.addFileEntry(attachment, groupId, userId, uniqueFileNameProvider);
        }
        if (Validator.isNotNull((String)attachment.getSrc())) {
            URL url = new URL(attachment.getSrc());
            if (Objects.equals("file", url.getProtocol())) {
                throw new CPAttachmentFileEntryProtocolException("Unsupported URL protocol");
            }
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            File file = FileUtil.createTempFile((InputStream)urlConnection.getInputStream());
            return AttachmentUtil._addFileEntry(groupId, userId, file, attachment.getContentType(), uniqueFileNameProvider);
        }
        return null;
    }

    public static FileEntry addFileEntry(AttachmentBase64 attachmentBase64, long groupId, long userId, UniqueFileNameProvider uniqueFileNameProvider) throws Exception {
        String base64EncodedContent = attachmentBase64.getAttachment();
        if (Validator.isNull((String)base64EncodedContent)) {
            return null;
        }
        File file = FileUtil.createTempFile((byte[])Base64.decode((String)base64EncodedContent));
        return AttachmentUtil._addFileEntry(groupId, userId, file, attachmentBase64.getContentType(), uniqueFileNameProvider);
    }

    public static FileEntry addFileEntry(AttachmentUrl attachmentUrl, long groupId, long userId, UniqueFileNameProvider uniqueFileNameProvider) throws Exception {
        if (Validator.isNull((String)attachmentUrl.getSrc())) {
            return null;
        }
        File file = FileUtil.createTempFile((InputStream)HttpUtil.URLtoInputStream((String)attachmentUrl.getSrc()));
        return AttachmentUtil._addFileEntry(groupId, userId, file, attachmentUrl.getContentType(), uniqueFileNameProvider);
    }

    public static CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(CPAttachmentFileEntryService cpAttachmentFileEntryService, UniqueFileNameProvider uniqueFileNameProvider, AttachmentBase64 attachmentBase64, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachmentBase64.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachmentBase64.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachmentBase64.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachmentBase64.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        long fileEntryId = 0L;
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachmentBase64, serviceContext.getScopeGroupId(), serviceContext.getUserId(), uniqueFileNameProvider);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        return cpAttachmentFileEntryService.addOrUpdateCPAttachmentFileEntry(attachmentBase64.getExternalReferenceCode(), serviceContext.getScopeGroupId(), classNameId, classPK, GetterUtil.getLong((Object)attachmentBase64.getId()), fileEntryId, false, null, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachmentBase64.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachmentBase64.getTitle()), GetterUtil.getString((Object)attachmentBase64.getOptions()), GetterUtil.getDouble((Object)attachmentBase64.getPriority()), type, serviceContext);
    }

    public static CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(CPAttachmentFileEntryService cpAttachmentFileEntryService, UniqueFileNameProvider uniqueFileNameProvider, AttachmentUrl attachmentUrl, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachmentUrl.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachmentUrl.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachmentUrl.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachmentUrl.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        long fileEntryId = 0L;
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachmentUrl, serviceContext.getScopeGroupId(), serviceContext.getUserId(), uniqueFileNameProvider);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        return cpAttachmentFileEntryService.addOrUpdateCPAttachmentFileEntry(attachmentUrl.getExternalReferenceCode(), serviceContext.getScopeGroupId(), classNameId, classPK, GetterUtil.getLong((Object)attachmentUrl.getId()), fileEntryId, false, null, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachmentUrl.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachmentUrl.getTitle()), GetterUtil.getString((Object)attachmentUrl.getOptions()), GetterUtil.getDouble((Object)attachmentUrl.getPriority()), type, serviceContext);
    }

    public static CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(long groupId, CPAttachmentFileEntryService cpAttachmentFileEntryService, UniqueFileNameProvider uniqueFileNameProvider, Attachment attachment, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachment.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachment.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachment.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachment.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        long fileEntryId = 0L;
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachment, serviceContext.getScopeGroupId(), serviceContext.getUserId(), uniqueFileNameProvider);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        return cpAttachmentFileEntryService.addOrUpdateCPAttachmentFileEntry(attachment.getExternalReferenceCode(), groupId, classNameId, classPK, GetterUtil.getLong((Object)attachment.getId()), fileEntryId, GetterUtil.get((Object)attachment.getCdnEnabled(), (boolean)false), GetterUtil.getString((String)attachment.getCdnURL()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachment.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachment.getTitle()), GetterUtil.getString((Object)attachment.getOptions()), GetterUtil.getDouble((Object)attachment.getPriority()), type, serviceContext);
    }

    public static Map<Locale, String> getTitleMap(CPAttachmentFileEntry cpAttachmentFileEntry, Map<String, String> titleMap) throws PortalException {
        if (titleMap != null) {
            return LanguageUtils.getLocalizedMap(titleMap);
        }
        if (cpAttachmentFileEntry == null) {
            return null;
        }
        return cpAttachmentFileEntry.getTitleMap();
    }

    private static FileEntry _addFileEntry(long groupId, long userId, File file, String contentType, UniqueFileNameProvider uniqueFileNameProvider) throws Exception {
        String uniqueFileName = uniqueFileNameProvider.provide(file.getName(), curFileName -> AttachmentUtil._exists(groupId, userId, curFileName));
        if (Validator.isNull((String)contentType)) {
            contentType = MimeTypesUtil.getContentType((File)file);
        }
        FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FILE_NAME, (String)uniqueFileName, (File)file, (String)contentType);
        FileUtil.delete((File)file);
        return fileEntry;
    }

    private static boolean _exists(long groupId, long userId, String curFileName) {
        try {
            FileEntry fileEntry = TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FILE_NAME, (String)curFileName);
            return fileEntry != null;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return false;
        }
    }
}

