/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.batch.v1_0;

import com.liferay.batch.engine.BaseBatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductChannel;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.CategoryHelper;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.ProductChannelHelper;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.ProductHelper;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.ProductSpecificationHelper;
import com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0.SkuHelper;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"batch.engine.task.item.delegate.name=commerce-ml-product"}, service={BatchEngineTaskItemDelegate.class})
public class CommerceMLProductBatchEngineTaskItemDelegate
extends BaseBatchEngineTaskItemDelegate<Product> {
    @Reference
    private CategoryHelper _categoryHelper;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ProductChannelHelper _productChannelHelper;
    @Reference
    private ProductDTOConverter _productDTOConverter;
    @Reference
    private ProductHelper _productHelper;
    @Reference
    private ProductSpecificationHelper _productSpecificationHelper;
    @Reference
    private SkuHelper _skuHelper;

    public Class<Product> getItemClass() {
        return Product.class;
    }

    public Page<Product> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        com.liferay.portal.vulcan.pagination.Pagination vulcanPagination = com.liferay.portal.vulcan.pagination.Pagination.of((int)pagination.getPage(), (int)pagination.getPageSize());
        com.liferay.portal.vulcan.pagination.Page<Product> productsPage = this._productHelper.getProductsPage(this.contextCompany.getCompanyId(), search, filter, vulcanPagination, sorts, (UnsafeFunction<Document, Product, Exception>)((UnsafeFunction)document -> {
            long productId = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._toProduct(productId, this.contextUser.getLocale());
        }), null);
        return Page.of((Collection)productsPage.getItems(), (Pagination)Pagination.of((int)((int)productsPage.getPage()), (int)((int)productsPage.getPageSize())), (long)productsPage.getTotalCount());
    }

    private Product _toProduct(long productId, Locale locale) throws Exception {
        Product product = this._productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(false, null, this._dtoConverterRegistry, (Object)productId, locale, null, this.contextUser));
        com.liferay.portal.vulcan.pagination.Pagination fullPagination = com.liferay.portal.vulcan.pagination.Pagination.of((int)-1, (int)-1);
        com.liferay.portal.vulcan.pagination.Page<ProductChannel> productChannelsPage = this._productChannelHelper.getProductChannelsPage(product.getId(), fullPagination);
        Collection productChannels = productChannelsPage.getItems();
        product.setProductChannels(productChannels.toArray(new ProductChannel[0]));
        com.liferay.portal.vulcan.pagination.Page<ProductSpecification> productSpecificationsPage = this._productSpecificationHelper.getProductSpecificationsPage(product.getProductId(), this.contextUser.getLocale(), fullPagination);
        Collection productSpecifications = productSpecificationsPage.getItems();
        product.setProductSpecifications(productSpecifications.toArray(new ProductSpecification[0]));
        com.liferay.portal.vulcan.pagination.Page<Category> categoriesPage = this._categoryHelper.getCategoriesPage(product.getProductId(), this.contextUser.getLocale(), fullPagination);
        Collection categories = categoriesPage.getItems();
        product.setCategories(categories.toArray(new Category[0]));
        com.liferay.portal.vulcan.pagination.Page<Sku> skusPage = this._skuHelper.getSkusPage(product.getProductId(), this.contextUser.getLocale(), fullPagination);
        Collection skus = skusPage.getItems();
        product.setSkus(skus.toArray(new Sku[0]));
        return product;
    }
}

