/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettingsFileEntry;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuVirtualSettingsFileEntryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.FileEntryUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuVirtualSettingsFileEntryResource;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.upload.UniqueFileNameProvider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku-virtual-settings-file-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={SkuVirtualSettingsFileEntryResource.class})
public class SkuVirtualSettingsFileEntryResourceImpl
extends BaseSkuVirtualSettingsFileEntryResourceImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private CPDVirtualSettingFileEntryService _cpdVirtualSettingFileEntryService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuVirtualSettingsFileEntryDTOConverter)")
    private DTOConverter<CPDefinition, SkuVirtualSettingsFileEntry> _skuVirtualSettingsFileEntryDTOConverter;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public void deleteSkuVirtualSettingsFileEntry(Long id) throws Exception {
        this._cpdVirtualSettingFileEntryService.deleteCPDVirtualSettingFileEntry(id.longValue());
    }

    @Override
    public Page<SkuVirtualSettingsFileEntry> getSkuVirtualSettingIdSkuVirtualSettingsFileEntriesPage(Long id, Pagination pagination) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(id.longValue());
        return Page.of(this.transform(cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries(pagination.getStartPosition(), pagination.getEndPosition()), this::_toSkuVirtualSettingsFileEntry), (Pagination)pagination, (long)cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntriesCount());
    }

    @Override
    public SkuVirtualSettingsFileEntry getSkuVirtualSettingsFileEntry(Long id) throws Exception {
        return this._toSkuVirtualSettingsFileEntry(this._cpdVirtualSettingFileEntryService.getCPDVirtualSettingFileEntry(id.longValue()));
    }

    @Override
    public SkuVirtualSettingsFileEntry patchSkuVirtualSettingsFileEntry(Long id, MultipartBody multipartBody) throws Exception {
        CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = this._cpdVirtualSettingFileEntryService.getCPDVirtualSettingFileEntry(id.longValue());
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpdVirtualSettingFileEntry.getCPDefinitionVirtualSetting();
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpDefinitionVirtualSetting.getClassPK());
        SkuVirtualSettingsFileEntry skuVirtualSettingsFileEntry = (SkuVirtualSettingsFileEntry)multipartBody.getValueAsNullableInstance("skuVirtualSettingsFileEntry", SkuVirtualSettingsFileEntry.class);
        long fileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(binaryFile, cpInstance.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider);
        } else if (skuVirtualSettingsFileEntry.getAttachment() != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(skuVirtualSettingsFileEntry.getAttachment(), skuVirtualSettingsFileEntry.getUrl(), cpInstance.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider, this._serviceContextHelper.getServiceContext(cpInstance.getGroupId()));
        }
        return this._toSkuVirtualSettingsFileEntry(this._cpdVirtualSettingFileEntryService.updateCPDefinitionVirtualSetting(id.longValue(), fileEntryId, GetterUtil.get((String)skuVirtualSettingsFileEntry.getUrl(), (String)cpdVirtualSettingFileEntry.getUrl()), GetterUtil.get((String)skuVirtualSettingsFileEntry.getVersion(), (String)cpdVirtualSettingFileEntry.getVersion())));
    }

    @Override
    public SkuVirtualSettingsFileEntry postSkuVirtualSettingIdSkuVirtualSettingsFileEntry(Long id, MultipartBody multipartBody) throws Exception {
        SkuVirtualSettingsFileEntry skuVirtualSettingsFileEntry = (SkuVirtualSettingsFileEntry)multipartBody.getValueAsNullableInstance("skuVirtualSettingsFileEntry", SkuVirtualSettingsFileEntry.class);
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null && skuVirtualSettingsFileEntry.getAttachment() == null) {
            throw new BadRequestException("No file found in body");
        }
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(id.longValue());
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpDefinitionVirtualSetting.getClassPK());
        long fileEntryId = 0L;
        if (binaryFile != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(binaryFile, cpInstance.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider);
        } else if (skuVirtualSettingsFileEntry.getAttachment() != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(skuVirtualSettingsFileEntry.getAttachment(), skuVirtualSettingsFileEntry.getUrl(), cpInstance.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider, this._serviceContextHelper.getServiceContext(cpInstance.getGroupId()));
        }
        return this._toSkuVirtualSettingsFileEntry(this._cpdVirtualSettingFileEntryService.addCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getGroupId(), CPInstance.class.getName(), cpDefinitionVirtualSetting.getClassPK(), cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), fileEntryId, GetterUtil.get((String)skuVirtualSettingsFileEntry.getUrl(), (String)""), GetterUtil.get((String)skuVirtualSettingsFileEntry.getVersion(), (String)"")));
    }

    private Map<String, Map<String, String>> _getActions(CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingId());
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpDefinitionVirtualSetting.getClassPK());
        long cpDefinitionId = cpInstance.getCPDefinitionId();
        return HashMapBuilder.put((Object)"delete", (Object)ActionUtil.addAction((String)"UPDATE", this.getClass(), (Long)cpDefinitionId, (String)"deleteSkuVirtualSettingsFileEntry", this._cpDefinitionModelResourcePermission, (Long)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), (UriInfo)this.contextUriInfo)).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", this.getClass(), (Long)cpDefinitionId, (String)"getSkuVirtualSettingsFileEntry", this._cpDefinitionModelResourcePermission, (Long)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), (UriInfo)this.contextUriInfo)).put((Object)"patch", (Object)ActionUtil.addAction((String)"UPDATE", this.getClass(), (Long)cpDefinitionId, (String)"patchSkuVirtualSettingsFileEntry", this._cpDefinitionModelResourcePermission, (Long)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), (UriInfo)this.contextUriInfo)).build();
    }

    private SkuVirtualSettingsFileEntry _toSkuVirtualSettingsFileEntry(CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry) throws Exception {
        return (SkuVirtualSettingsFileEntry)this._skuVirtualSettingsFileEntryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpdVirtualSettingFileEntry), this._dtoConverterRegistry, (Object)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

