/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOptionValue;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinitionOptionRel"}, service={DTOConverter.class})
public class ProductOptionDTOConverter
implements DTOConverter<CPDefinitionOptionRel, ProductOption> {
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPOptionLocalService _cpOptionLocalService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductOptionValueDTOConverter)")
    private DTOConverter<CPDefinitionOptionValueRel, ProductOptionValue> _productOptionValueDTOConverter;

    public String getContentType() {
        return ProductOption.class.getSimpleName();
    }

    public ProductOption toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(((Long)dtoConverterContext.getId()).longValue());
        final CPOption cpOption = this._cpOptionLocalService.fetchCPOption(cpDefinitionOptionRel.getCPOptionId());
        return new ProductOption(){
            {
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)CPDefinitionOptionRel.class.getName(), (long)cpDefinitionOptionRel.getCPDefinitionOptionRelId(), (long)cpDefinitionOptionRel.getCompanyId(), (Locale)dtoConverterContext.getLocale()));
                this.setDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinitionOptionRel.getDescriptionMap()));
                this.setFacetable(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).isFacetable());
                this.setFieldType(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getCommerceOptionTypeKey());
                this.setId(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getCPDefinitionOptionRelId());
                this.setKey(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getKey());
                this.setName(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinitionOptionRel.getNameMap()));
                this.setOptionExternalReferenceCode(() -> {
                    if (cpOption == null) {
                        return null;
                    }
                    return cpOption.getExternalReferenceCode();
                });
                this.setOptionId(() -> {
                    if (cpOption == null) {
                        return null;
                    }
                    return cpOption.getCPOptionId();
                });
                this.setPriceType(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getPriceType());
                this.setProductOptionValues(() -> {
                    if (!GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("showProductOptionValues"))) {
                        return null;
                    }
                    return ProductOptionDTOConverter.this._toProductOptionValues(cpDefinitionOptionRel, dtoConverterContext);
                });
                this.setRequired(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).isRequired());
                this.setSkuContributor(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).isSkuContributor());
                this.setTypeSettings(() -> ((CPDefinitionOptionRel)cpDefinitionOptionRel).getTypeSettings());
            }
        };
    }

    private ProductOptionValue[] _toProductOptionValues(CPDefinitionOptionRel cpDefinitionOptionRel, DTOConverterContext dtoConverterContext) throws Exception {
        return (ProductOptionValue[])TransformUtil.transformToArray((Collection)this._cpDefinitionOptionValueRelService.getCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), -1, -1), cpDefinitionOptionValueRel -> (ProductOptionValue)this._productOptionValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId(), dtoConverterContext.getLocale()), cpDefinitionOptionValueRel), ProductOptionValue.class);
    }
}

