/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;

public class ProductConfigurationUtil {
    public static String getAllowedOrderQuantities(BigDecimal[] allowedOrderQuantities, String defaultAllowedOrderQuantities) {
        if (allowedOrderQuantities != null) {
            return StringUtil.merge((Object[])allowedOrderQuantities, (String)" ");
        }
        if (Validator.isNull((String)defaultAllowedOrderQuantities)) {
            return null;
        }
        return defaultAllowedOrderQuantities;
    }

    public static void updateCPDAvailabilityEstimate(CPDAvailabilityEstimateService cpdAvailabilityEstimateService, ProductConfiguration productConfiguration, long cpDefinitionId) throws PortalException {
        long commerceAvailabilityEstimateId = 0L;
        CPDAvailabilityEstimate cpdAvailabilityEstimate = cpdAvailabilityEstimateService.fetchCPDAvailabilityEstimateByCPDefinitionId(cpDefinitionId);
        if (cpdAvailabilityEstimate != null) {
            commerceAvailabilityEstimateId = cpdAvailabilityEstimate.getCommerceAvailabilityEstimateId();
        }
        cpdAvailabilityEstimateService.updateCPDAvailabilityEstimate(0L, cpDefinitionId, GetterUtil.get((Object)productConfiguration.getAvailabilityEstimateId(), (long)commerceAvailabilityEstimateId));
    }

    public static CPDefinitionInventory updateCPDefinitionInventory(CPDefinitionInventoryService cpDefinitionInventoryService, ProductConfiguration productConfiguration, long cpDefinitionId) throws PortalException {
        CPDefinitionInventory cpDefinitionInventory = cpDefinitionInventoryService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinitionId);
        return cpDefinitionInventoryService.updateCPDefinitionInventory(cpDefinitionInventory.getCPDefinitionInventoryId(), GetterUtil.get((String)productConfiguration.getInventoryEngine(), (String)cpDefinitionInventory.getCPDefinitionInventoryEngine()), productConfiguration.getLowStockAction(), GetterUtil.get((Object)productConfiguration.getDisplayAvailability(), (boolean)cpDefinitionInventory.isDisplayAvailability()), GetterUtil.get((Object)productConfiguration.getDisplayStockQuantity(), (boolean)cpDefinitionInventory.isDisplayStockQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinStockQuantity(), (BigDecimal)cpDefinitionInventory.getMinStockQuantity()), GetterUtil.get((Object)productConfiguration.getAllowBackOrder(), (boolean)cpDefinitionInventory.isBackOrders()), BigDecimalUtil.get((Object)productConfiguration.getMinOrderQuantity(), (BigDecimal)cpDefinitionInventory.getMinOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMaxOrderQuantity(), (BigDecimal)cpDefinitionInventory.getMaxOrderQuantity()), ProductConfigurationUtil.getAllowedOrderQuantities(productConfiguration.getAllowedOrderQuantities(), cpDefinitionInventory.getAllowedOrderQuantities()), BigDecimalUtil.get((Object)productConfiguration.getMultipleOrderQuantity(), (BigDecimal)cpDefinitionInventory.getMultipleOrderQuantity()));
    }
}

