/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuUnitOfMeasure;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSkuUnitOfMeasureResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUnitOfMeasureUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SkuUnitOfMeasureResource;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/sku-unit-of-measure.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={SkuUnitOfMeasureResource.class})
public class SkuUnitOfMeasureResourceImpl
extends BaseSkuUnitOfMeasureResourceImpl {
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPInstanceUnitOfMeasure)")
    private ModelResourcePermission<CPInstanceUnitOfMeasure> _cpInstanceUnitOfMeasureModelResourcePermission;
    @Reference
    private CPInstanceUnitOfMeasureService _cpInstanceUnitOfMeasureService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SkuUnitOfMeasureDTOConverter)")
    private DTOConverter<CPInstanceUnitOfMeasure, SkuUnitOfMeasure> _skuUnitOfMeasureDTOConverter;

    @Override
    public void deleteSkuUnitOfMeasure(Long id) throws Exception {
        this._cpInstanceUnitOfMeasureService.deleteCPInstanceUnitOfMeasure(id.longValue());
    }

    @Override
    public Page<SkuUnitOfMeasure> getSkuByExternalReferenceCodeSkuUnitOfMeasuresPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchCPInstanceByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        return Page.of(this.transform(this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasures(cpInstance.getCPInstanceId(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toSkuUnitOfMeasure), (Pagination)pagination, (long)this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(cpInstance.getCPInstanceId()));
    }

    @Override
    @NestedField(parentClass=Sku.class, value="skuUnitOfMeasures")
    public Page<SkuUnitOfMeasure> getSkuIdSkuUnitOfMeasuresPage(Long id, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasures(id.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toSkuUnitOfMeasure), (Pagination)pagination, (long)this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(id.longValue()));
    }

    @Override
    public SkuUnitOfMeasure getSkuUnitOfMeasure(Long id) throws Exception {
        return this._toSkuUnitOfMeasure(this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasure(id.longValue()));
    }

    @Override
    public SkuUnitOfMeasure patchSkuUnitOfMeasure(Long id, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasure(id.longValue());
        Map nameMap = skuUnitOfMeasure.getName();
        if (nameMap == null || nameMap.isEmpty()) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)cpInstanceUnitOfMeasure.getNameMap());
        }
        cpInstanceUnitOfMeasure = this._cpInstanceUnitOfMeasureService.updateCPInstanceUnitOfMeasure(id.longValue(), cpInstanceUnitOfMeasure.getCPInstanceId(), GetterUtil.get((Object)skuUnitOfMeasure.getActive(), (boolean)cpInstanceUnitOfMeasure.isActive()), BigDecimalUtil.get((Object)skuUnitOfMeasure.getIncrementalOrderQuantity(), (BigDecimal)cpInstanceUnitOfMeasure.getIncrementalOrderQuantity()), cpInstanceUnitOfMeasure.getKey(), LanguageUtils.getLocalizedMap((Map)nameMap), GetterUtil.get((Object)skuUnitOfMeasure.getPrecision(), (int)cpInstanceUnitOfMeasure.getPrecision()), BigDecimalUtil.get((Object)skuUnitOfMeasure.getPricingQuantity(), (BigDecimal)cpInstanceUnitOfMeasure.getPricingQuantity()), GetterUtil.get((Object)skuUnitOfMeasure.getPrimary(), (boolean)cpInstanceUnitOfMeasure.isPrimary()), GetterUtil.get((Object)skuUnitOfMeasure.getPriority(), (double)cpInstanceUnitOfMeasure.getPriority()), BigDecimalUtil.get((Object)skuUnitOfMeasure.getRate(), (BigDecimal)cpInstanceUnitOfMeasure.getRate()), cpInstanceUnitOfMeasure.getSku());
        if (skuUnitOfMeasure.getBasePrice() != null || skuUnitOfMeasure.getPromoPrice() != null) {
            CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceUnitOfMeasure.getCPInstanceId());
            if (skuUnitOfMeasure.getBasePrice() != null) {
                SkuUnitOfMeasureUtil.updateCommercePriceEntry(this._commercePriceEntryService, this._commercePriceListLocalService, cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getBasePrice(), "price-list", this._serviceContextHelper.getServiceContext());
            }
            if (skuUnitOfMeasure.getPromoPrice() != null) {
                SkuUnitOfMeasureUtil.updateCommercePriceEntry(this._commercePriceEntryService, this._commercePriceListLocalService, cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getPromoPrice(), "promotion", this._serviceContextHelper.getServiceContext());
            }
        }
        return this._toSkuUnitOfMeasure(cpInstanceUnitOfMeasure);
    }

    @Override
    public SkuUnitOfMeasure postSkuByExternalReferenceCodeSkuUnitOfMeasure(String externalReferenceCode, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        CPInstance cpInstance = this._cpInstanceService.fetchCPInstanceByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpInstance == null) {
            throw new NoSuchCPInstanceException("Unable to find SKU with external reference code " + externalReferenceCode);
        }
        return this._toSkuUnitOfMeasure(SkuUnitOfMeasureUtil.addOrUpdateCPInstanceUnitOfMeasure(this._cpInstanceUnitOfMeasureService, this._commercePriceEntryService, this._commercePriceListLocalService, cpInstance, skuUnitOfMeasure, this._serviceContextHelper.getServiceContext()));
    }

    @Override
    public SkuUnitOfMeasure postSkuIdSkuUnitOfMeasure(Long id, SkuUnitOfMeasure skuUnitOfMeasure) throws Exception {
        return this._toSkuUnitOfMeasure(SkuUnitOfMeasureUtil.addOrUpdateCPInstanceUnitOfMeasure(this._cpInstanceUnitOfMeasureService, this._commercePriceEntryService, this._commercePriceListLocalService, this._cpInstanceService.getCPInstance(id.longValue()), skuUnitOfMeasure, this._serviceContextHelper.getServiceContext()));
    }

    private Map<String, Map<String, String>> _getActions(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId(), "deleteSkuUnitOfMeasure", this._cpInstanceUnitOfMeasureModelResourcePermission)).put((Object)"get", this.addAction("VIEW", cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId(), "getSkuUnitOfMeasure", this._cpInstanceUnitOfMeasureModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId(), "patchSkuUnitOfMeasure", this._cpInstanceUnitOfMeasureModelResourcePermission)).build();
    }

    private SkuUnitOfMeasure _toSkuUnitOfMeasure(CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure) throws Exception {
        return (SkuUnitOfMeasure)this._skuUnitOfMeasureDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpInstanceUnitOfMeasure), null, (Object)cpInstanceUnitOfMeasure.getCPInstanceUnitOfMeasureId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

