/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.MappedProductDTOConverter;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseMappedProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.MappedProductUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.MappedProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldSupport;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(enabled=false, properties={"OSGI-INF/liferay/rest/v1_0/mapped-product.properties"}, scope=ServiceScope.PROTOTYPE, service={MappedProductResource.class, NestedFieldSupport.class})
public class MappedProductResourceImpl
extends BaseMappedProductResourceImpl
implements NestedFieldSupport {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;
    @Reference
    private MappedProductDTOConverter _mappedProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteMappedProduct(Long mappedProductId) throws Exception {
        this._csDiagramEntryService.deleteCSDiagramEntry(mappedProductId.longValue());
    }

    @Override
    public MappedProduct getProductByExternalReferenceCodeMappedProductBySequence(String externalReferenceCode, String sequence) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.fetchCSDiagramEntry(cpDefinition.getCPDefinitionId(), sequence);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    @Override
    public Page<MappedProduct> getProductByExternalReferenceCodeMappedProductsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._getMappedProductsPage(cpDefinition.getCPDefinitionId(), pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="mappedProducts")
    public Page<MappedProduct> getProductIdMappedProductsPage(Long productId, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        return this._getMappedProductsPage(cpDefinition.getCPDefinitionId(), pagination);
    }

    @Override
    public MappedProduct getProductMappedProductBySequence(Long productId, String sequence) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.fetchCSDiagramEntry(cpDefinition.getCPDefinitionId(), sequence);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    @Override
    public MappedProduct patchMappedProduct(Long mappedProductId, MappedProduct mappedProduct) throws Exception {
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.getCSDiagramEntry(mappedProductId.longValue());
        CPDefinition cpDefinition = csDiagramEntry.getCPDefinition();
        MappedProductUtil.updateCSDiagramEntry(this.contextCompany.getCompanyId(), csDiagramEntry, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
        return this._toMappedProduct(mappedProductId);
    }

    @Override
    public MappedProduct postProductByExternalReferenceCodeMappedProduct(String externalReferenceCode, MappedProduct mappedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CSDiagramEntry csDiagramEntry = MappedProductUtil.addCSDiagramEntry(this.contextCompany.getCompanyId(), cpDefinition.getCPDefinitionId(), this._cpDefinitionService, this._cpInstanceService, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    @Override
    public MappedProduct postProductIdMappedProduct(Long productId, MappedProduct mappedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CSDiagramEntry csDiagramEntry = MappedProductUtil.addCSDiagramEntry(this.contextCompany.getCompanyId(), cpDefinition.getCPDefinitionId(), this._cpDefinitionService, this._cpInstanceService, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    private Page<MappedProduct> _getMappedProductsPage(long cpDefinitionId, Pagination pagination) throws Exception {
        return Page.of(this.transform(this._csDiagramEntryService.getCSDiagramEntries(cpDefinitionId, pagination.getStartPosition(), pagination.getEndPosition()), csDiagramEntry -> this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId())), (Pagination)pagination, (long)this._csDiagramEntryService.getCSDiagramEntriesCount(cpDefinitionId));
    }

    private MappedProduct _toMappedProduct(long csDiagramEntryId) throws Exception {
        return this._mappedProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)csDiagramEntryId, this.contextAcceptLanguage.getPreferredLocale()));
    }
}

