/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettingsFileEntry;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductVirtualSettingsFileEntryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.FileEntryUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductVirtualSettingsFileEntryResource;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.upload.UniqueFileNameProvider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-virtual-settings-file-entry.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductVirtualSettingsFileEntryResource.class})
public class ProductVirtualSettingsFileEntryResourceImpl
extends BaseProductVirtualSettingsFileEntryResourceImpl {
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private CPDVirtualSettingFileEntryService _cpdVirtualSettingFileEntryService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductVirtualSettingsFileEntryDTOConverter)")
    private DTOConverter<CPDefinition, ProductVirtualSettingsFileEntry> _productVirtualSettingsFileEntryDTOConverter;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public void deleteProductVirtualSettingsFileEntry(Long id) throws Exception {
        this._cpdVirtualSettingFileEntryService.deleteCPDVirtualSettingFileEntry(id.longValue());
    }

    @Override
    public Page<ProductVirtualSettingsFileEntry> getProductVirtualSettingIdProductVirtualSettingsFileEntriesPage(Long id, Pagination pagination) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(id.longValue());
        return Page.of(this.transform(cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries(pagination.getStartPosition(), pagination.getEndPosition()), this::_toProductVirtualSettingsFileEntry), (Pagination)pagination, (long)cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntriesCount());
    }

    @Override
    public ProductVirtualSettingsFileEntry getProductVirtualSettingsFileEntry(Long id) throws Exception {
        return this._toProductVirtualSettingsFileEntry(this._cpdVirtualSettingFileEntryService.getCPDVirtualSettingFileEntry(id.longValue()));
    }

    @Override
    public ProductVirtualSettingsFileEntry patchProductVirtualSettingsFileEntry(Long id, MultipartBody multipartBody) throws Exception {
        CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = this._cpdVirtualSettingFileEntryService.getCPDVirtualSettingFileEntry(id.longValue());
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingId());
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionVirtualSetting.getClassPK());
        ProductVirtualSettingsFileEntry productVirtualSettingsFileEntry = (ProductVirtualSettingsFileEntry)multipartBody.getValueAsNullableInstance("productVirtualSettingsFileEntry", ProductVirtualSettingsFileEntry.class);
        long fileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(binaryFile, cpDefinition.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider);
        } else if (productVirtualSettingsFileEntry.getAttachment() != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettingsFileEntry.getAttachment(), productVirtualSettingsFileEntry.getUrl(), cpDefinition.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        }
        return this._toProductVirtualSettingsFileEntry(this._cpdVirtualSettingFileEntryService.updateCPDefinitionVirtualSetting(id.longValue(), fileEntryId, GetterUtil.get((String)productVirtualSettingsFileEntry.getUrl(), (String)cpdVirtualSettingFileEntry.getUrl()), GetterUtil.get((String)productVirtualSettingsFileEntry.getVersion(), (String)cpdVirtualSettingFileEntry.getVersion())));
    }

    @Override
    public ProductVirtualSettingsFileEntry postProductVirtualSettingIdProductVirtualSettingsFileEntry(Long id, MultipartBody multipartBody) throws Exception {
        ProductVirtualSettingsFileEntry productVirtualSettingsFileEntry = (ProductVirtualSettingsFileEntry)multipartBody.getValueAsNullableInstance("productVirtualSettingsFileEntry", ProductVirtualSettingsFileEntry.class);
        BinaryFile binaryFile = multipartBody.getBinaryFile("file");
        if (binaryFile == null && productVirtualSettingsFileEntry.getAttachment() == null) {
            throw new BadRequestException("No file found in body");
        }
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(id.longValue());
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionVirtualSetting.getClassPK());
        long fileEntryId = 0L;
        if (binaryFile != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(binaryFile, cpDefinition.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider);
        } else if (productVirtualSettingsFileEntry.getAttachment() != null) {
            fileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettingsFileEntry.getAttachment(), productVirtualSettingsFileEntry.getUrl(), cpDefinition.getGroupId(), this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        }
        return this._toProductVirtualSettingsFileEntry(this._cpdVirtualSettingFileEntryService.addCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getGroupId(), CPDefinition.class.getName(), cpDefinitionVirtualSetting.getClassPK(), cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), fileEntryId, GetterUtil.get((String)productVirtualSettingsFileEntry.getUrl(), (String)""), GetterUtil.get((String)productVirtualSettingsFileEntry.getVersion(), (String)"")));
    }

    private Map<String, Map<String, String>> _getActions(CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = this._cpDefinitionVirtualSettingService.getCPDefinitionVirtualSetting(cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingId());
        return HashMapBuilder.put((Object)"delete", (Object)ActionUtil.addAction((String)"UPDATE", this.getClass(), (Long)cpDefinitionVirtualSetting.getClassPK(), (String)"deleteProductVirtualSettingsFileEntry", this._cpDefinitionModelResourcePermission, (Long)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), (UriInfo)this.contextUriInfo)).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", this.getClass(), (Long)cpDefinitionVirtualSetting.getClassPK(), (String)"getProductVirtualSettingsFileEntry", this._cpDefinitionModelResourcePermission, (Long)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), (UriInfo)this.contextUriInfo)).put((Object)"patch", (Object)ActionUtil.addAction((String)"UPDATE", this.getClass(), (Long)cpDefinitionVirtualSetting.getClassPK(), (String)"patchProductVirtualSettingsFileEntry", this._cpDefinitionModelResourcePermission, (Long)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), (UriInfo)this.contextUriInfo)).build();
    }

    private ProductVirtualSettingsFileEntry _toProductVirtualSettingsFileEntry(CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry) throws Exception {
        return (ProductVirtualSettingsFileEntry)this._productVirtualSettingsFileEntryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpdVirtualSettingFileEntry), this._dtoConverterRegistry, (Object)cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

