/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CommerceCatalog"}, service={DTOConverter.class})
public class CatalogDTOConverter
implements DTOConverter<CommerceCatalog, Catalog> {
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;

    public String getContentType() {
        return Catalog.class.getSimpleName();
    }

    public Catalog toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceCatalog commerceCatalog = this._commerceCatalogService.getCommerceCatalog(((Long)dtoConverterContext.getId()).longValue());
        final CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceCatalog.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
        return new Catalog(){
            {
                this.setAccountId(() -> ((CommerceCatalog)commerceCatalog).getAccountEntryId());
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setCurrencyCode(() -> ((CommerceCurrency)commerceCurrency).getCode());
                this.setCurrencyExternalReferenceCode(() -> ((CommerceCurrency)commerceCurrency).getExternalReferenceCode());
                this.setCurrencyId(() -> ((CommerceCurrency)commerceCurrency).getCommerceCurrencyId());
                this.setDefaultLanguageId(() -> ((CommerceCatalog)commerceCatalog).getCatalogDefaultLanguageId());
                this.setExternalReferenceCode(() -> ((CommerceCatalog)commerceCatalog).getExternalReferenceCode());
                this.setId(() -> ((CommerceCatalog)commerceCatalog).getCommerceCatalogId());
                this.setName(() -> ((CommerceCatalog)commerceCatalog).getName());
                this.setSystem(() -> ((CommerceCatalog)commerceCatalog).isSystem());
            }
        };
    }
}

