/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroup;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductGroupResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.crud.VulcanCRUDItemDelegate;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/v1.0")
public abstract class BaseProductGroupResourceImpl
implements EntityModelResource,
ProductGroupResource,
VulcanBatchEngineTaskItemDelegate<ProductGroup>,
VulcanCRUDItemDelegate<ProductGroup> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<ProductGroup>, UnsafeFunction<ProductGroup, ProductGroup, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<ProductGroup>, UnsafeConsumer<ProductGroup, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseProductGroupResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Tags(value={@Tag(name="ProductGroup")})
    @DELETE
    @Path(value="/product-groups/{id}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteProductGroup(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/product-groups/batch")
    @Produces(value={"application/json"})
    public Response deleteProductGroupBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(ProductGroup.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ProductGroup")})
    @DELETE
    @Path(value="/product-groups/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteProductGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Tags(value={@Tag(name="ProductGroup")})
    @GET
    @Path(value="/product-groups/{id}")
    @Produces(value={"application/json", "application/xml"})
    public ProductGroup getProductGroup(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id) throws Exception {
        return new ProductGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ProductGroup")})
    @GET
    @Path(value="/product-groups/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public ProductGroup getProductGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new ProductGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="ProductGroup")})
    @GET
    @Path(value="/product-groups")
    @Produces(value={"application/json", "application/xml"})
    public Page<ProductGroup> getProductGroupsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/product-groups/{id}")
    @Produces(value={"application/json", "application/xml"})
    public Response patchProductGroup(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id, ProductGroup productGroup) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/product-groups/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Response patchProductGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, ProductGroup productGroup) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/product-groups")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ProductGroup postProductGroup(ProductGroup productGroup) throws Exception {
        return new ProductGroup();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json"})
    @Path(value="/product-groups/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postProductGroupBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(ProductGroup.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort"), @Parameter(in=ParameterIn.QUERY, name="callbackURL"), @Parameter(in=ParameterIn.QUERY, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="fieldNames")})
    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json"})
    @Path(value="/product-groups/export-batch")
    @POST
    @Produces(value={"application/json"})
    public Response postProductGroupsPageExportBatch(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Sort[] sorts, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, @Parameter(hidden=true) @DefaultValue(value="JSON") @QueryParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="fieldNames") String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineExportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineExportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineExportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineExportTaskResource.setContextUser(this.contextUser);
        this.vulcanBatchEngineExportTaskResource.setGroupLocalService(this.groupLocalService);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineExportTaskResource.postExportTask(ProductGroup.class.getName(), callbackURL, contentType, fieldNames)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ProductGroup")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/product-groups/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public ProductGroup putProductGroupByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, ProductGroup productGroup) throws Exception {
        return new ProductGroup();
    }

    public void create(Collection<ProductGroup> productGroups, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction productGroupUnsafeFunction = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
            productGroupUnsafeFunction = productGroup -> this.postProductGroup((ProductGroup)productGroup);
        }
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
            String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
                productGroupUnsafeFunction = productGroup -> {
                    ProductGroup getProductGroup = null;
                    ProductGroup persistedProductGroup = null;
                    try {
                        getProductGroup = this.getProductGroupByExternalReferenceCode(productGroup.getExternalReferenceCode());
                        this.patchProductGroup(getProductGroup.getId(), (ProductGroup)productGroup);
                    }
                    catch (NoSuchModelException noSuchModelException) {
                        persistedProductGroup = this.postProductGroup((ProductGroup)productGroup);
                    }
                    return persistedProductGroup;
                };
            }
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
                productGroupUnsafeFunction = productGroup -> {
                    ProductGroup persistedProductGroup = null;
                    persistedProductGroup = this.putProductGroupByExternalReferenceCode(productGroup.getExternalReferenceCode(), (ProductGroup)productGroup);
                    return persistedProductGroup;
                };
            }
        }
        if (productGroupUnsafeFunction == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for ProductGroup");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(productGroups, (Object)productGroupUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(productGroups, arg_0 -> ((UnsafeFunction)productGroupUnsafeFunction).apply(arg_0));
        } else {
            for (ProductGroup productGroup2 : productGroups) {
                productGroupUnsafeFunction.apply((Object)productGroup2);
            }
        }
    }

    public void delete(Collection<ProductGroup> productGroups, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction productGroupUnsafeFunction = productGroup -> {
            if (productGroup.getId() != null) {
                try {
                    this.deleteProductGroup(productGroup.getId());
                    return productGroup;
                }
                catch (Exception exception) {
                    if (productGroup.getExternalReferenceCode() != null) {
                        this.deleteProductGroupByExternalReferenceCode(productGroup.getExternalReferenceCode());
                        return productGroup;
                    }
                }
            } else if (productGroup.getExternalReferenceCode() != null) {
                this.deleteProductGroupByExternalReferenceCode(productGroup.getExternalReferenceCode());
                return productGroup;
            }
            throw new UnsupportedOperationException("Unable to delete by external reference code or ID");
        };
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(productGroups, (Object)productGroupUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(productGroups, arg_0 -> ((UnsafeFunction)productGroupUnsafeFunction).apply(arg_0));
        } else {
            for (ProductGroup productGroup2 : productGroups) {
                productGroupUnsafeFunction.apply((Object)productGroup2);
            }
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT", "UPSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "ProductGroup";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<ProductGroup> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getProductGroupsPage(search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<ProductGroup> productGroups, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction productGroupUnsafeFunction = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
            productGroupUnsafeFunction = productGroup -> {
                this.patchProductGroup(productGroup.getId(), (ProductGroup)productGroup);
                return null;
            };
        }
        if (productGroupUnsafeFunction == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for ProductGroup");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(productGroups, (Object)productGroupUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(productGroups, arg_0 -> ((UnsafeFunction)productGroupUnsafeFunction).apply(arg_0));
        } else {
            for (ProductGroup productGroup2 : productGroups) {
                productGroupUnsafeFunction.apply((Object)productGroup2);
            }
        }
    }

    public ProductGroup getItem(Long id) throws Exception {
        return this.getProductGroup(id);
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<ProductGroup>, UnsafeFunction<ProductGroup, ProductGroup, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<ProductGroup>, UnsafeConsumer<ProductGroup, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-commerce-admin-catalog";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

