/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeRegistry;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Status;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"application.name=Liferay.Headless.Commerce.Admin.Catalog", "dto.class.name=com.liferay.commerce.product.model.CPDefinition", "version=v1.0"}, service={DTOConverter.class})
public class ProductDTOConverter
implements DTOConverter<CPDefinition, Product> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPTypeRegistry _cpTypeRegistry;
    @Reference
    private Language _language;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        final CProduct cProduct = cpDefinition.getCProduct();
        final Locale locale = dtoConverterContext.getLocale();
        final CPType cpType = this._getCPType(cpDefinition.getProductTypeName());
        return new Product(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setActive(() -> !cpDefinition.isInactive());
                this.setCatalogExternalReferenceCode(() -> {
                    CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
                    if (commerceCatalog == null) {
                        return null;
                    }
                    return commerceCatalog.getExternalReferenceCode();
                });
                this.setCatalogId(() -> ProductDTOConverter.this._getCommerceCatalogId(cpDefinition));
                this.setCategories(() -> (Category[])TransformUtil.transformToArray((Collection)ProductDTOConverter.this._assetCategoryLocalService.getCategories(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()), assetCategory -> ProductDTOConverter.this._toCategory((AssetCategory)assetCategory), Category.class));
                this.setCreateDate(() -> ((CPDefinition)cpDefinition).getCreateDate());
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields((boolean)dtoConverterContext.isAcceptAllLanguages(), (String)CPDefinition.class.getName(), (long)cpDefinition.getCPDefinitionId(), (long)cpDefinition.getCompanyId(), (Locale)dtoConverterContext.getLocale()));
                this.setDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap()));
                this.setDisplayDate(() -> ((CPDefinition)cpDefinition).getDisplayDate());
                this.setExpando(() -> {
                    ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
                    return expandoBridge.getAttributes();
                });
                this.setExpirationDate(() -> ((CPDefinition)cpDefinition).getExpirationDate());
                this.setExternalReferenceCode(() -> ((CProduct)cProduct).getExternalReferenceCode());
                this.setId(() -> ((CPDefinition)cpDefinition).getCPDefinitionId());
                this.setMetaDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap()));
                this.setMetaKeyword(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap()));
                this.setMetaTitle(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap()));
                this.setModifiedDate(() -> ((CPDefinition)cpDefinition).getModifiedDate());
                this.setName(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap()));
                this.setProductAccountGroupFilter(() -> ((CPDefinition)cpDefinition).isAccountGroupFilterEnabled());
                this.setProductChannelFilter(() -> ((CPDefinition)cpDefinition).isChannelFilterEnabled());
                this.setProductId(() -> ((CProduct)cProduct).getCProductId());
                this.setProductStatus(() -> ((CPDefinition)cpDefinition).getStatus());
                this.setProductType(() -> ((CPType)cpType).getName());
                this.setProductTypeI18n(() -> cpType.getLabel(locale));
                this.setShortDescription(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap()));
                this.setSkuFormatted(() -> ProductDTOConverter.this._getSku(cpDefinition, dtoConverterContext.getLocale()));
                this.setTags(() -> (String[])TransformUtil.transformToArray((Collection)ProductDTOConverter.this._assetTagService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()), AssetTagModel::getName, String.class));
                this.setThumbnail(() -> cpDefinition.getDefaultImageThumbnailSrc(Long.MIN_VALUE));
                this.setUrls(() -> LanguageUtils.getLanguageIdMap((Map)ProductDTOConverter.this._cpDefinitionService.getUrlTitleMap(cpDefinition.getCPDefinitionId())));
                this.setVersion(() -> ((CPDefinition)cpDefinition).getVersion());
                this.setWorkflowStatusInfo(() -> {
                    ResourceBundle resourceBundle = LanguageResources.getResourceBundle((Locale)locale);
                    String productStatusLabel = WorkflowConstants.getStatusLabel((int)cpDefinition.getStatus());
                    String productStatusLabelI18n = ProductDTOConverter.this._language.get(resourceBundle, WorkflowConstants.getStatusLabel((int)cpDefinition.getStatus()));
                    return ProductDTOConverter.this._toStatus(cpDefinition.getStatus(), productStatusLabel, productStatusLabelI18n);
                });
            }
        };
    }

    private long _getCommerceCatalogId(CPDefinition cpDefinition) {
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }

    private CPType _getCPType(String name) {
        return this._cpTypeRegistry.getCPType(name);
    }

    private String _getSku(CPDefinition cpDefinition, Locale locale) {
        List cpInstances = cpDefinition.getCPInstances();
        if (cpInstances.isEmpty()) {
            return "";
        }
        if (cpInstances.size() > 1) {
            return this._language.get(locale, "multiple-skus");
        }
        CPInstance cpInstance = (CPInstance)cpInstances.get(0);
        return cpInstance.getSku();
    }

    private Category _toCategory(final AssetCategory assetCategory) {
        return new Category(){
            {
                this.setExternalReferenceCode(() -> ((AssetCategory)assetCategory).getExternalReferenceCode());
                this.setId(() -> ((AssetCategory)assetCategory).getCategoryId());
                this.setName(() -> ((AssetCategory)assetCategory).getName());
                this.setVocabulary(() -> {
                    AssetVocabulary assetVocabulary = ProductDTOConverter.this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
                    if (assetVocabulary == null) {
                        return null;
                    }
                    return assetVocabulary.getName();
                });
            }
        };
    }

    private Status _toStatus(final int statusCode, final String productStatusLabel, final String productStatusLabelI18n) {
        return new Status(){
            {
                this.setCode(() -> statusCode);
                this.setLabel(() -> productStatusLabel);
                this.setLabel_i18n(() -> productStatusLabelI18n);
            }
        };
    }
}

