/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class MappedProductUtil {
    public static CSDiagramEntry addCSDiagramEntry(long companyId, long cpDefinitionId, CPDefinitionService cpDefinitionService, CPInstanceService cpInstanceService, CSDiagramEntryService csDiagramEntryService, long groupId, Locale locale, MappedProduct mappedProduct, ServiceContextHelper serviceContextHelper) throws PortalException {
        long skuId = GetterUtil.getLong((Object)mappedProduct.getSkuId());
        CPInstance cpInstance = cpInstanceService.fetchCPInstanceByExternalReferenceCode(mappedProduct.getSkuExternalReferenceCode(), companyId);
        if (cpInstance != null) {
            skuId = cpInstance.getCPInstanceId();
        }
        long productId = GetterUtil.getLong((Object)mappedProduct.getProductId());
        CPDefinition cpDefinition = cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(mappedProduct.getProductExternalReferenceCode(), companyId);
        if (cpDefinition != null) {
            productId = cpDefinition.getCProductId();
        }
        ServiceContext serviceContext = serviceContextHelper.getServiceContext(groupId);
        serviceContext.setExpandoBridgeAttributes(MappedProductUtil.getExpandoBridgeAttributes(companyId, locale, mappedProduct));
        return csDiagramEntryService.addCSDiagramEntry(cpDefinitionId, skuId, productId, MappedProductUtil.isDiagram(null, mappedProduct), GetterUtil.getInteger((Object)mappedProduct.getQuantity()), GetterUtil.getString((String)mappedProduct.getSequence()), GetterUtil.getString((String)mappedProduct.getSku()), serviceContext);
    }

    public static CSDiagramEntry addOrUpdateCSDiagramEntry(long companyId, long cpDefinitionId, CPDefinitionService cpDefinitionService, CPInstanceService cpInstanceService, CSDiagramEntryService csDiagramEntryService, long groupId, Locale locale, MappedProduct mappedProduct, ServiceContextHelper serviceContextHelper) throws PortalException {
        CSDiagramEntry csDiagramEntry = csDiagramEntryService.fetchCSDiagramEntry(cpDefinitionId, mappedProduct.getSequence());
        if (csDiagramEntry == null) {
            return MappedProductUtil.addCSDiagramEntry(companyId, cpDefinitionId, cpDefinitionService, cpInstanceService, csDiagramEntryService, groupId, locale, mappedProduct, serviceContextHelper);
        }
        return MappedProductUtil.updateCSDiagramEntry(companyId, csDiagramEntry, csDiagramEntryService, groupId, locale, mappedProduct, serviceContextHelper);
    }

    public static Map<String, Serializable> getExpandoBridgeAttributes(long companyId, Locale locale, MappedProduct mappedProduct) {
        HashMap expandoBridgeAttributes = CustomFieldsUtil.toMap((String)CSDiagramEntry.class.getName(), (long)companyId, (CustomField[])mappedProduct.getCustomFields(), (Locale)locale);
        if (expandoBridgeAttributes == null) {
            expandoBridgeAttributes = new HashMap();
        }
        return expandoBridgeAttributes;
    }

    public static boolean isDiagram(CSDiagramEntry csDiagramEntry, MappedProduct mappedProduct) {
        if (csDiagramEntry == null && mappedProduct.getType() == null) {
            return false;
        }
        if (mappedProduct.getType() != null) {
            return Objects.equals(MappedProduct.Type.DIAGRAM.getValue(), mappedProduct.getTypeAsString());
        }
        return csDiagramEntry.isDiagram();
    }

    public static CSDiagramEntry updateCSDiagramEntry(long companyId, CSDiagramEntry csDiagramEntry, CSDiagramEntryService csDiagramEntryService, long groupId, Locale locale, MappedProduct mappedProduct, ServiceContextHelper serviceContextHelper) throws PortalException {
        ServiceContext serviceContext = serviceContextHelper.getServiceContext(groupId);
        serviceContext.setExpandoBridgeAttributes(MappedProductUtil.getExpandoBridgeAttributes(companyId, locale, mappedProduct));
        return csDiagramEntryService.updateCSDiagramEntry(csDiagramEntry.getCSDiagramEntryId(), GetterUtil.get((Object)mappedProduct.getSkuId(), (long)csDiagramEntry.getCPInstanceId()), GetterUtil.get((Object)mappedProduct.getProductId(), (long)csDiagramEntry.getCProductId()), MappedProductUtil.isDiagram(csDiagramEntry, mappedProduct), GetterUtil.get((Object)mappedProduct.getQuantity(), (int)csDiagramEntry.getQuantity()), GetterUtil.get((String)mappedProduct.getSequence(), (String)csDiagramEntry.getSequence()), GetterUtil.get((String)mappedProduct.getSku(), (String)csDiagramEntry.getSku()), serviceContext);
    }
}

