/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationList;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductConfigurationListResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationListResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationResource;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-configuration-list.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductConfigurationListResource.class})
public class ProductConfigurationListResourceImpl
extends BaseProductConfigurationListResourceImpl {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPConfigurationList)")
    private ModelResourcePermission<CPConfigurationList> _cpConfigurationListModelResourcePermission;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationListDTOConverter)")
    private DTOConverter<CPConfigurationList, ProductConfigurationList> _productConfigurationListDTOConverter;
    @Reference
    private ProductConfigurationResource _productConfigurationResource;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteProductConfigurationList(Long id) throws Exception {
        this._cpConfigurationListService.deleteCPConfigurationList(id.longValue());
    }

    @Override
    public void deleteProductConfigurationListByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteProductConfigurationList(cpConfigurationList.getCPConfigurationListId());
    }

    @Override
    public ProductConfigurationList getProductConfigurationList(Long id) throws Exception {
        return this._toProductConfigurationList(id);
    }

    @Override
    public ProductConfigurationList getProductConfigurationListByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.getProductConfigurationList(cpConfigurationList.getCPConfigurationListId());
    }

    @Override
    public Page<ProductConfigurationList> getProductConfigurationListsPage(Long catalogId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPConfigurationList.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (GetterUtil.getLong((Object)catalogId) > 0L) {
                CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(catalogId.longValue());
                searchContext.setGroupIds(new long[]{commerceCatalog.getGroupId()});
            } else {
                searchContext.setGroupIds(this.transformToLongArray(this._commerceCatalogLocalService.search(this.contextCompany.getCompanyId()), CommerceCatalog::getGroupId));
            }
        }, (Sort[])sorts, document -> this._toProductConfigurationList(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public ProductConfigurationList patchProductConfigurationList(Long id, ProductConfigurationList productConfigurationList) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationList(id.longValue());
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpConfigurationList.getGroupId());
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)GetterUtil.getDate((Object)productConfigurationList.getDisplayDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpConfigurationList.getDisplayDate()), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)GetterUtil.getDate((Object)productConfigurationList.getExpirationDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpConfigurationList.getExpirationDate()), (TimeZone)serviceContext.getTimeZone());
        cpConfigurationList = this._cpConfigurationListService.updateCPConfigurationList(GetterUtil.getString((String)productConfigurationList.getExternalReferenceCode(), (String)cpConfigurationList.getExternalReferenceCode()), cpConfigurationList.getCPConfigurationListId(), cpConfigurationList.getGroupId(), cpConfigurationList.getParentCPConfigurationListId(), cpConfigurationList.isMaster(), GetterUtil.getString((String)productConfigurationList.getName(), (String)cpConfigurationList.getName()), GetterUtil.getDouble((Object)productConfigurationList.getPriority(), (double)cpConfigurationList.getPriority()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)productConfigurationList.getNeverExpire(), (boolean)true));
        Object[] productConfigurations = productConfigurationList.getProductConfigurations();
        if (productConfigurations != null && ArrayUtil.isNotEmpty((Object[])productConfigurations)) {
            this._productConfigurationResource.setContextAcceptLanguage(this.contextAcceptLanguage);
            this._productConfigurationResource.setContextCompany(this.contextCompany);
            this._productConfigurationResource.setContextUriInfo(this.contextUriInfo);
            for (Object productConfiguration : productConfigurations) {
                this._productConfigurationResource.patchProductConfiguration(productConfiguration.getId(), (ProductConfiguration)productConfiguration);
            }
        }
        return this._toProductConfigurationList(cpConfigurationList);
    }

    @Override
    public ProductConfigurationList patchProductConfigurationListByExternalReferenceCode(String externalReferenceCode, ProductConfigurationList productConfigurationList) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.patchProductConfigurationList(cpConfigurationList.getCPConfigurationListId(), productConfigurationList);
    }

    @Override
    public ProductConfigurationList postProductConfigurationList(ProductConfigurationList productConfigurationList) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByExternalReferenceCode(GetterUtil.getString((String)productConfigurationList.getCatalogExternalReferenceCode()), this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(GetterUtil.getLong((Object)productConfigurationList.getCatalogId()));
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceCatalog.getGroupId());
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)productConfigurationList.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)productConfigurationList.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.addOrUpdateCPConfigurationList(GetterUtil.getString((String)productConfigurationList.getExternalReferenceCode()), this.contextCompany.getCompanyId(), commerceCatalog.getGroupId(), GetterUtil.getLong((Object)productConfigurationList.getParentProductConfigurationListId()), GetterUtil.getBoolean((Object)productConfigurationList.getMaster()), GetterUtil.getString((String)productConfigurationList.getName()), GetterUtil.getDouble((Object)productConfigurationList.getPriority()), displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)productConfigurationList.getNeverExpire(), (boolean)true));
        Object[] productConfigurations = productConfigurationList.getProductConfigurations();
        if (productConfigurations != null && ArrayUtil.isNotEmpty((Object[])productConfigurations)) {
            this._productConfigurationResource.setContextAcceptLanguage(this.contextAcceptLanguage);
            this._productConfigurationResource.setContextCompany(this.contextCompany);
            this._productConfigurationResource.setContextUriInfo(this.contextUriInfo);
            for (Object productConfiguration : productConfigurations) {
                this._productConfigurationResource.postProductConfigurationListIdProductConfiguration(Long.valueOf(cpConfigurationList.getCPConfigurationListId()), (ProductConfiguration)productConfiguration);
            }
        }
        return this._toProductConfigurationList(cpConfigurationList);
    }

    private Map<String, Map<String, String>> _getActions(CPConfigurationList cpConfigurationList) {
        return HashMapBuilder.put((Object)"delete", () -> {
            if (cpConfigurationList.isMaster()) {
                return null;
            }
            return this.addAction("UPDATE", cpConfigurationList.getCPConfigurationListId(), "deleteProductConfigurationList", this._cpConfigurationListModelResourcePermission);
        }).put((Object)"get", () -> this.addAction("VIEW", cpConfigurationList.getCPConfigurationListId(), "getProductConfigurationList", this._cpConfigurationListModelResourcePermission)).put((Object)"update", () -> this.addAction("UPDATE", cpConfigurationList.getCPConfigurationListId(), "patchProductConfigurationList", this._cpConfigurationListModelResourcePermission)).build();
    }

    private ProductConfigurationList _toProductConfigurationList(CPConfigurationList cpConfigurationList) throws Exception {
        return (ProductConfigurationList)this._productConfigurationListDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpConfigurationList), this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)cpConfigurationList.getCPConfigurationListId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private ProductConfigurationList _toProductConfigurationList(long cpConfigurationListId) throws Exception {
        return this._toProductConfigurationList(this._cpConfigurationListService.getCPConfigurationList(cpConfigurationListId));
    }
}

