/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramPin;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Pin;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BasePinResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.MappedProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.PinUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.PinResource;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/pin.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={PinResource.class})
public class PinResourceImpl
extends BasePinResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;
    @Reference
    private CSDiagramPinService _csDiagramPinService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.PinDTOConverter)")
    private DTOConverter<CSDiagramEntry, Pin> _pinDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deletePin(Long pinId) throws Exception {
        CSDiagramPin csDiagramPin = this._csDiagramPinService.getCSDiagramPin(pinId.longValue());
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.fetchCSDiagramEntry(csDiagramPin.getCPDefinitionId(), csDiagramPin.getSequence());
        if (csDiagramEntry != null && !ListUtil.exists((List)this._csDiagramPinService.getCSDiagramPins(csDiagramPin.getCPDefinitionId(), -1, -1), curCSDiagramPin -> csDiagramPin.getCSDiagramPinId() != curCSDiagramPin.getCSDiagramPinId() && Objects.equals(csDiagramPin.getSequence(), curCSDiagramPin.getSequence()))) {
            this._csDiagramEntryService.deleteCSDiagramEntry(csDiagramEntry);
        }
        this._csDiagramPinService.deleteCSDiagramPin(csDiagramPin);
    }

    @Override
    public Page<Pin> getProductByExternalReferenceCodePinsPage(String externalReferenceCode, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code: " + externalReferenceCode);
        }
        return Page.of(this._toPins(this._csDiagramPinService.getCSDiagramPins(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._csDiagramPinService.getCSDiagramPinsCount(cpDefinition.getCPDefinitionId()));
    }

    @Override
    @NestedField(parentClass=Product.class, value="pins")
    public Page<Pin> getProductIdPinsPage(Long productId, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        return Page.of(this._toPins(this._csDiagramPinService.getCSDiagramPins(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._csDiagramPinService.getCSDiagramPinsCount(cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Pin patchPin(Long pinId, Pin pin) throws Exception {
        CSDiagramPin csDiagramPin = this._csDiagramPinService.getCSDiagramPin(pinId.longValue());
        PinUtil.updateCSDiagramPin(csDiagramPin, this._csDiagramPinService, pin);
        CPDefinition cpDefinition = csDiagramPin.getCPDefinition();
        this._addOrUpdateMappedProduct(csDiagramPin.getCPDefinitionId(), cpDefinition.getGroupId(), pin);
        return this._toPin(pinId);
    }

    @Override
    public Pin postProductByExternalReferenceCodePin(String externalReferenceCode, Pin pin) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addPin(cpDefinition.getCPDefinitionId(), cpDefinition.getGroupId(), pin);
    }

    @Override
    public Pin postProductIdPin(Long productId, Pin pin) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        return this._addPin(cpDefinition.getCPDefinitionId(), cpDefinition.getGroupId(), pin);
    }

    private void _addOrUpdateMappedProduct(long cpDefinitionId, long groupId, Pin pin) throws Exception {
        MappedProduct mappedProduct = pin.getMappedProduct();
        if (mappedProduct != null) {
            long skuId = GetterUtil.getLong((Object)mappedProduct.getSkuId());
            CPInstance cpInstance = this._cpInstanceService.fetchCPInstanceByExternalReferenceCode(mappedProduct.getSkuExternalReferenceCode(), this.contextCompany.getCompanyId());
            if (cpInstance != null) {
                skuId = cpInstance.getCPInstanceId();
            }
            long productId = GetterUtil.getLong((Object)mappedProduct.getProductId());
            CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(mappedProduct.getProductExternalReferenceCode(), this.contextCompany.getCompanyId());
            if (cpDefinition != null) {
                productId = cpDefinition.getCProductId();
            }
            ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(groupId);
            serviceContext.setExpandoBridgeAttributes(MappedProductUtil.getExpandoBridgeAttributes(this.contextCompany.getCompanyId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct));
            CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.fetchCSDiagramEntry(cpDefinitionId, GetterUtil.getString((String)pin.getSequence()));
            if (csDiagramEntry == null) {
                this._csDiagramEntryService.addCSDiagramEntry(cpDefinitionId, skuId, productId, MappedProductUtil.isDiagram(csDiagramEntry, mappedProduct), GetterUtil.getInteger((Object)mappedProduct.getQuantity()), GetterUtil.getString((String)mappedProduct.getSequence()), GetterUtil.getString((String)mappedProduct.getSku()), serviceContext);
            } else {
                this._csDiagramEntryService.updateCSDiagramEntry(csDiagramEntry.getCSDiagramEntryId(), skuId, productId, MappedProductUtil.isDiagram(csDiagramEntry, mappedProduct), GetterUtil.getInteger((Object)mappedProduct.getQuantity()), GetterUtil.getString((String)mappedProduct.getSequence()), GetterUtil.getString((String)mappedProduct.getSku()), serviceContext);
            }
        }
    }

    private Pin _addPin(long cpDefinitionId, long groupId, Pin pin) throws Exception {
        CSDiagramPin csDiagramPin = PinUtil.addCSDiagramPin(cpDefinitionId, this._csDiagramPinService, pin);
        this._addOrUpdateMappedProduct(cpDefinitionId, groupId, pin);
        return this._toPin(csDiagramPin.getCSDiagramPinId());
    }

    private Pin _toPin(long csDiagramPinId) throws Exception {
        return (Pin)this._pinDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)csDiagramPinId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<Pin> _toPins(List<CSDiagramPin> csDiagramPins) {
        return this.transform(csDiagramPins, csDiagramPin -> this._toPin(csDiagramPin.getCSDiagramPinId()));
    }
}

