/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCatalogException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.CatalogEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseCatalogResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.core.helper.ServiceContextHelper;
import com.liferay.headless.commerce.core.util.CommerceCurrencyUtil;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/catalog.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={CatalogResource.class})
public class CatalogResourceImpl
extends BaseCatalogResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(CatalogResourceImpl.class);
    private static final EntityModel _entityModel = new CatalogEntityModel();
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.CatalogDTOConverter)")
    private DTOConverter<CommerceCatalog, Catalog> _catalogDTOConverter;
    @Reference
    private CommerceCatalogService _commerceCatalogService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteCatalog(Long id) throws Exception {
        this._commerceCatalogService.deleteCommerceCatalog(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response deleteCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find catalog with external reference code " + externalReferenceCode);
        }
        this._commerceCatalogService.deleteCommerceCatalog(commerceCatalog.getCommerceCatalogId());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Catalog getCatalog(Long id) throws Exception {
        return this._toCatalog(this._commerceCatalogService.getCommerceCatalog(id.longValue()));
    }

    @Override
    public Catalog getCatalogByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find catalog with external reference code " + externalReferenceCode);
        }
        return this._toCatalog(commerceCatalog);
    }

    @Override
    public Page<Catalog> getCatalogsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CommerceCatalog.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toCatalog(this._commerceCatalogService.getCommerceCatalog(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Catalog getProductByExternalReferenceCodeCatalog(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toCatalog(cpDefinition.getCommerceCatalog());
    }

    @Override
    @NestedField(parentClass=Product.class, value="catalog")
    public Catalog getProductIdCatalog(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._toCatalog(cpDefinition.getCommerceCatalog());
    }

    @Override
    public Response patchCatalog(Long id, Catalog catalog) throws Exception {
        this._updateCommerceCatalog(catalog, this._commerceCatalogService.getCommerceCatalog(id.longValue()));
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchCatalogByExternalReferenceCode(String externalReferenceCode, Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException("Unable to find catalog with external reference code " + externalReferenceCode);
        }
        this._updateCommerceCatalog(catalog, commerceCatalog);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Catalog postCatalog(Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByExternalReferenceCode(catalog.getExternalReferenceCode(), this.contextCompany.getCompanyId());
        if (commerceCatalog == null) {
            CommerceCurrency commerceCurrency = CommerceCurrencyUtil.getCommerceCurrency((long)this.contextCompany.getCompanyId(), (String)catalog.getCurrencyCode(), (String)catalog.getCurrencyExternalReferenceCode(), (long)GetterUtil.getLong((Object)catalog.getCurrencyId()));
            commerceCatalog = this._commerceCatalogService.addCommerceCatalog(catalog.getExternalReferenceCode(), GetterUtil.get((Object)catalog.getAccountId(), (long)0L), catalog.getName(), commerceCurrency.getCode(), catalog.getDefaultLanguageId(), this._serviceContextHelper.getServiceContext());
        } else {
            CommerceCurrency commerceCurrency;
            block4: {
                commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(this.contextCompany.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
                try {
                    commerceCurrency = CommerceCurrencyUtil.getCommerceCurrency((long)this.contextCompany.getCompanyId(), (String)catalog.getCurrencyCode(), (String)catalog.getCurrencyExternalReferenceCode(), (long)GetterUtil.getLong((Object)catalog.getCurrencyId()));
                }
                catch (NoSuchCurrencyException noSuchCurrencyException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Throwable)noSuchCurrencyException);
                }
            }
            commerceCatalog = this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), GetterUtil.get((Object)catalog.getAccountId(), (long)commerceCatalog.getAccountEntryId()), GetterUtil.get((String)catalog.getName(), (String)commerceCatalog.getName()), commerceCurrency.getCode(), GetterUtil.get((String)catalog.getDefaultLanguageId(), (String)commerceCatalog.getCatalogDefaultLanguageId()));
        }
        return this._toCatalog(commerceCatalog);
    }

    @Override
    public Catalog putCatalogByExternalReferenceCode(String externalReferenceCode, Catalog catalog) throws Exception {
        CommerceCatalog commerceCatalog = this._commerceCatalogService.fetchCommerceCatalogByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        CommerceCurrency commerceCurrency = CommerceCurrencyUtil.getCommerceCurrency((long)this.contextCompany.getCompanyId(), (String)catalog.getCurrencyCode(), (String)catalog.getCurrencyExternalReferenceCode(), (long)GetterUtil.getLong((Object)catalog.getCurrencyId()));
        commerceCatalog = commerceCatalog == null ? this._commerceCatalogService.addCommerceCatalog(catalog.getExternalReferenceCode(), GetterUtil.get((Object)catalog.getAccountId(), (long)0L), catalog.getName(), commerceCurrency.getCode(), catalog.getDefaultLanguageId(), this._serviceContextHelper.getServiceContext()) : this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), GetterUtil.getLong((Object)catalog.getAccountId()), GetterUtil.getString((String)catalog.getName()), commerceCurrency.getCode(), GetterUtil.getString((String)catalog.getDefaultLanguageId()));
        return this._toCatalog(commerceCatalog);
    }

    private Map<String, Map<String, String>> _getActions(CommerceCatalog commerceCatalog) {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", commerceCatalog.getCommerceCatalogId(), "deleteCatalog", commerceCatalog.getUserId(), "com.liferay.commerce.product.model.CommerceCatalog", commerceCatalog.getGroupId())).put((Object)"get", this.addAction("VIEW", commerceCatalog.getCommerceCatalogId(), "getCatalog", commerceCatalog.getUserId(), "com.liferay.commerce.product.model.CommerceCatalog", commerceCatalog.getGroupId())).put((Object)"update", this.addAction("UPDATE", commerceCatalog.getCommerceCatalogId(), "patchCatalog", commerceCatalog.getUserId(), "com.liferay.commerce.product.model.CommerceCatalog", commerceCatalog.getGroupId())).build();
    }

    private Catalog _toCatalog(CommerceCatalog commerceCatalog) throws Exception {
        return (Catalog)this._catalogDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceCatalog), this._dtoConverterRegistry, (Object)commerceCatalog.getCommerceCatalogId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateCommerceCatalog(Catalog catalog, CommerceCatalog commerceCatalog) throws Exception {
        CommerceCurrency commerceCurrency;
        block2: {
            commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(this.contextCompany.getCompanyId(), commerceCatalog.getCommerceCurrencyCode());
            try {
                commerceCurrency = CommerceCurrencyUtil.getCommerceCurrency((long)this.contextCompany.getCompanyId(), (String)catalog.getCurrencyCode(), (String)catalog.getCurrencyExternalReferenceCode(), (long)GetterUtil.getLong((Object)catalog.getCurrencyId()));
            }
            catch (NoSuchCurrencyException noSuchCurrencyException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)noSuchCurrencyException);
            }
        }
        this._commerceCatalogService.updateCommerceCatalog(commerceCatalog.getCommerceCatalogId(), GetterUtil.get((Object)catalog.getAccountId(), (long)commerceCatalog.getAccountEntryId()), GetterUtil.get((String)catalog.getName(), (String)commerceCatalog.getName()), commerceCurrency.getCode(), GetterUtil.get((String)catalog.getDefaultLanguageId(), (String)commerceCatalog.getCatalogDefaultLanguageId()));
    }
}

