/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryLocalService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuVirtualSettingsFileEntry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry"}, service={DTOConverter.class})
public class SkuVirtualSettingsFileEntryDTOConverter
implements DTOConverter<CPDVirtualSettingFileEntry, SkuVirtualSettingsFileEntry> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPDefinitionVirtualSettingLocalService _cpDefinitionVirtualSettingLocalService;
    @Reference
    private CPDVirtualSettingFileEntryLocalService _cpdVirtualSettingFileEntryLocalService;

    public String getContentType() {
        return SkuVirtualSettingsFileEntry.class.getSimpleName();
    }

    public SkuVirtualSettingsFileEntry toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = this._cpdVirtualSettingFileEntryLocalService.getCPDVirtualSettingFileEntry(((Long)dtoConverterContext.getId()).longValue());
        return new SkuVirtualSettingsFileEntry(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setId(() -> ((CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntry).getCPDefinitionVirtualSettingFileEntryId());
                this.setSrc(() -> {
                    long fileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
                    if (fileEntryId == 0L) {
                        return null;
                    }
                    CPDefinitionVirtualSetting cpDefinitionVirtualSetting = SkuVirtualSettingsFileEntryDTOConverter.this._cpDefinitionVirtualSettingLocalService.getCPDefinitionVirtualSetting(cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingId());
                    return SkuVirtualSettingsFileEntryDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPInstance.class.getName(), cpDefinitionVirtualSetting.getClassPK(), Long.MIN_VALUE, fileEntryId);
                });
                this.setUrl(() -> {
                    if (Validator.isBlank((String)cpdVirtualSettingFileEntry.getUrl())) {
                        return null;
                    }
                    return cpdVirtualSettingFileEntry.getUrl();
                });
                this.setVersion(() -> {
                    if (Validator.isBlank((String)cpdVirtualSettingFileEntry.getVersion())) {
                        return null;
                    }
                    return cpdVirtualSettingFileEntry.getVersion();
                });
            }
        };
    }
}

