/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue"}, service={DTOConverter.class})
public class ProductSpecificationDTOConverter
implements DTOConverter<CPDefinitionSpecificationOptionValue, ProductSpecification> {
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;

    public String getContentType() {
        return ProductSpecification.class.getSimpleName();
    }

    public ProductSpecification toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(((Long)dtoConverterContext.getId()).longValue());
        final CPSpecificationOption cpSpecificationOption = cpDefinitionSpecificationOptionValue.getCPSpecificationOption();
        return new ProductSpecification(){
            {
                this.setExternalReferenceCode(() -> ((CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue).getExternalReferenceCode());
                this.setId(() -> ((CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue).getCPDefinitionSpecificationOptionValueId());
                this.setKey(() -> ((CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue).getKey());
                this.setLabel(() -> LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getTitleMap()));
                this.setOptionCategoryExternalReferenceCode(() -> {
                    CPOptionCategory cpOptionCategory = cpSpecificationOption.getCPOptionCategory();
                    if (cpOptionCategory == null) {
                        return null;
                    }
                    return cpOptionCategory.getExternalReferenceCode();
                });
                this.setOptionCategoryId(() -> ((CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue).getCPOptionCategoryId());
                this.setPriority(() -> ((CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue).getPriority());
                this.setProductId(() -> {
                    CPDefinition cpDefinition = cpDefinitionSpecificationOptionValue.getCPDefinition();
                    return cpDefinition.getCProductId();
                });
                this.setSpecificationExternalReferenceCode(() -> ((CPSpecificationOption)cpSpecificationOption).getExternalReferenceCode());
                this.setSpecificationId(() -> ((CPSpecificationOption)cpSpecificationOption).getCPSpecificationOptionId());
                this.setSpecificationKey(() -> ((CPSpecificationOption)cpSpecificationOption).getKey());
                this.setSpecificationPriority(() -> ((CPSpecificationOption)cpSpecificationOption).getPriority());
                this.setValue(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinitionSpecificationOptionValue.getValueMap()));
                this.setVisible(() -> ((CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue).isVisible());
            }
        };
    }
}

