/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.price.list.exception.CommercePriceEntryPriceException;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceUnitOfMeasure;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuUnitOfMeasure;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import java.math.BigDecimal;
import java.util.Map;

public class SkuUnitOfMeasureUtil {
    public static CPInstanceUnitOfMeasure addOrUpdateCPInstanceUnitOfMeasure(CPInstanceUnitOfMeasureService cpInstanceUnitOfMeasureService, CommercePriceEntryService commercePriceEntryService, CommercePriceListLocalService commercePriceListLocalService, CPInstance cpInstance, SkuUnitOfMeasure skuUnitOfMeasure, ServiceContext serviceContext) throws Exception {
        CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure = cpInstanceUnitOfMeasureService.addOrUpdateCPInstanceUnitOfMeasure(cpInstance.getCPInstanceId(), GetterUtil.get((Object)skuUnitOfMeasure.getActive(), (boolean)true), (BigDecimal)GetterUtil.getNumber((Object)skuUnitOfMeasure.getIncrementalOrderQuantity(), (Number)BigDecimal.ONE), skuUnitOfMeasure.getKey(), LanguageUtils.getLocalizedMap((Map)skuUnitOfMeasure.getName()), GetterUtil.getInteger((Object)skuUnitOfMeasure.getPrecision()), skuUnitOfMeasure.getPricingQuantity(), GetterUtil.get((Object)skuUnitOfMeasure.getPrimary(), (boolean)SkuUnitOfMeasureUtil._isDefaultPrimary(cpInstanceUnitOfMeasureService, cpInstance.getCPInstanceId())), GetterUtil.getDouble((Object)skuUnitOfMeasure.getPriority()), (BigDecimal)GetterUtil.getNumber((Object)skuUnitOfMeasure.getRate(), (Number)BigDecimal.ONE), cpInstance.getSku());
        int count = cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(cpInstance.getCPInstanceId());
        if (count > 1 && skuUnitOfMeasure.getBasePrice() == null) {
            throw new CommercePriceEntryPriceException();
        }
        if (skuUnitOfMeasure.getBasePrice() != null) {
            SkuUnitOfMeasureUtil.updateCommercePriceEntry(commercePriceEntryService, commercePriceListLocalService, cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getBasePrice(), "price-list", serviceContext);
        }
        if (skuUnitOfMeasure.getPromoPrice() != null) {
            SkuUnitOfMeasureUtil.updateCommercePriceEntry(commercePriceEntryService, commercePriceListLocalService, cpInstance, cpInstanceUnitOfMeasure, skuUnitOfMeasure.getPromoPrice(), "promotion", serviceContext);
        }
        return cpInstanceUnitOfMeasure;
    }

    public static void updateCommercePriceEntry(CommercePriceEntryService commercePriceEntryService, CommercePriceListLocalService commercePriceListLocalService, CPInstance cpInstance, CPInstanceUnitOfMeasure cpInstanceUnitOfMeasure, BigDecimal price, String type, ServiceContext serviceContext) throws Exception {
        if (price == null) {
            return;
        }
        CommercePriceEntry commercePriceEntry = commercePriceEntryService.getInstanceBaseCommercePriceEntry(cpInstance.getCPInstanceUuid(), type, cpInstanceUnitOfMeasure.getKey());
        if (commercePriceEntry == null) {
            CommercePriceList commercePriceList = commercePriceListLocalService.getCatalogBaseCommercePriceListByType(cpInstance.getGroupId(), type);
            commercePriceEntryService.addCommercePriceEntry(null, cpInstance.getCPInstanceId(), commercePriceList.getCommercePriceListId(), price, false, null, cpInstanceUnitOfMeasure.getKey(), serviceContext);
        } else {
            commercePriceEntryService.updatePricingInfo(commercePriceEntry.getCommercePriceEntryId(), commercePriceEntry.isBulkPricing(), price, commercePriceEntry.isPriceOnApplication(), commercePriceEntry.getPromoPrice(), cpInstanceUnitOfMeasure.getKey(), serviceContext);
        }
    }

    private static boolean _isDefaultPrimary(CPInstanceUnitOfMeasureService cpInstanceUnitOfMeasureService, long cpInstanceId) throws Exception {
        int count = cpInstanceUnitOfMeasureService.getCPInstanceUnitOfMeasuresCount(cpInstanceId);
        return count <= 0;
    }
}

