/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPSpecificationOptionException;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.SpecificationEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSpecificationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SpecificationResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.model.ListTypeDefinitionModel;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/specification.properties"}, scope=ServiceScope.PROTOTYPE, service={SpecificationResource.class})
public class SpecificationResourceImpl
extends BaseSpecificationResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SpecificationResourceImpl.class);
    private static final EntityModel _entityModel = new SpecificationEntityModel();
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.SpecificationDTOConverter)")
    private DTOConverter<CPSpecificationOption, Specification> _specificationDTOConverter;

    @Override
    public void deleteSpecification(Long id) throws Exception {
        this._cpSpecificationOptionService.deleteCPSpecificationOption(id.longValue());
    }

    @Override
    public void deleteSpecificationByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.fetchCPSpecificationOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpSpecificationOption == null) {
            throw new NoSuchCPSpecificationOptionException();
        }
        this.deleteSpecification(cpSpecificationOption.getCPSpecificationOptionId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Specification getSpecification(Long id) throws Exception {
        return this._toSpecification(GetterUtil.getLong((Object)id));
    }

    @Override
    public Specification getSpecificationByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.fetchCPSpecificationOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpSpecificationOption == null) {
            throw new NoSuchCPSpecificationOptionException();
        }
        return this.getSpecification(cpSpecificationOption.getCPSpecificationOptionId());
    }

    @Override
    public Page<Specification> getSpecificationsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPSpecificationOption.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toSpecification(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Specification patchSpecification(Long id, Specification specification) throws Exception {
        CPSpecificationOption cpSpecificationOption = this._updateSpecification(this._cpSpecificationOptionService.getCPSpecificationOption(id.longValue()), specification);
        return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
    }

    @Override
    public Specification patchSpecificationByExternalReferenceCode(String externalReferenceCode, Specification specification) throws Exception {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.fetchCPSpecificationOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpSpecificationOption == null) {
            throw new NoSuchCPSpecificationOptionException();
        }
        return this.patchSpecification(cpSpecificationOption.getCPSpecificationOptionId(), specification);
    }

    @Override
    public Specification postSpecification(Specification specification) throws Exception {
        return this._addOrUpdateSpecification(specification);
    }

    @Override
    public Specification putSpecificationByExternalReferenceCode(String externalReferenceCode, Specification specification) throws Exception {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.fetchCPSpecificationOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        long[] listTypeDefinitionIds = GetterUtil.getLongValues((Object)specification.getListTypeDefinitionIds(), (long[])new long[]{GetterUtil.getLong((Object)specification.getListTypeDefinitionId())});
        if (cpSpecificationOption == null) {
            cpSpecificationOption = this._cpSpecificationOptionService.addCPSpecificationOption(specification.getExternalReferenceCode(), this._getCPOptionCategoryId(specification), listTypeDefinitionIds, LanguageUtils.getLocalizedMap((Map)specification.getTitle()), LanguageUtils.getLocalizedMap((Map)specification.getDescription()), GetterUtil.getBoolean((Object)specification.getFacetable()), GetterUtil.getString((String)specification.getKey()), GetterUtil.getDouble((Object)specification.getPriority()), GetterUtil.getBoolean((Object)specification.getVisible(), (boolean)true), this._serviceContextHelper.getServiceContext());
            return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
        }
        Map descriptionMap = specification.getDescription();
        Map titleMap = specification.getTitle();
        this._cpSpecificationOptionService.updateCPSpecificationOption(GetterUtil.getString((String)specification.getExternalReferenceCode()), cpSpecificationOption.getCPSpecificationOptionId(), GetterUtil.getLong((Object)this._getCPOptionCategoryId(specification)), listTypeDefinitionIds, LanguageUtils.getLocalizedMap((Map)titleMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), GetterUtil.getBoolean((Object)specification.getFacetable()), GetterUtil.getString((String)specification.getKey()), GetterUtil.getDouble((Object)specification.getPriority()), GetterUtil.getBoolean((Object)specification.getVisible(), (boolean)cpSpecificationOption.isVisible()), this._serviceContextHelper.getServiceContext());
        return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
    }

    private Specification _addOrUpdateSpecification(Specification specification) throws Exception {
        String specificationKey;
        block12: {
            block11: {
                String specificationExternalReferenceCode;
                Long specificationId;
                block10: {
                    specificationId = specification.getId();
                    if (specificationId != null) {
                        try {
                            CPSpecificationOption cpSpecificationOption = this._updateSpecification(this._cpSpecificationOptionService.getCPSpecificationOption(specificationId.longValue()), specification);
                            return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
                        }
                        catch (NoSuchCPSpecificationOptionException noSuchCPSpecificationOptionException) {
                            if (!_log.isDebugEnabled()) break block10;
                            _log.debug((Object)("Unable to find specification with ID: " + specificationId), (Throwable)noSuchCPSpecificationOptionException);
                        }
                    }
                }
                if (Validator.isNotNull((String)(specificationExternalReferenceCode = specification.getExternalReferenceCode()))) {
                    try {
                        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.fetchCPSpecificationOptionByExternalReferenceCode(specificationExternalReferenceCode, this.contextCompany.getCompanyId());
                        if (cpSpecificationOption == null) {
                            throw new NoSuchCPSpecificationOptionException();
                        }
                        cpSpecificationOption = this._updateSpecification(cpSpecificationOption, specification);
                        return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
                    }
                    catch (NoSuchCPSpecificationOptionException noSuchCPSpecificationOptionException) {
                        if (!_log.isDebugEnabled()) break block11;
                        _log.debug((Object)("Unable to find specification with external reference code: " + specificationId), (Throwable)noSuchCPSpecificationOptionException);
                    }
                }
            }
            if (Validator.isNotNull((String)(specificationKey = specification.getKey()))) {
                try {
                    CPSpecificationOption cpSpecificationOption = this._updateSpecification(this._cpSpecificationOptionService.getCPSpecificationOption(this.contextCompany.getCompanyId(), specificationKey), specification);
                    return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
                }
                catch (NoSuchCPSpecificationOptionException noSuchCPSpecificationOptionException) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug((Object)("Unable to find specification with key: " + specificationKey), (Throwable)noSuchCPSpecificationOptionException);
                }
            }
        }
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.addCPSpecificationOption(specification.getExternalReferenceCode(), this._getCPOptionCategoryId(specification), GetterUtil.getLongValues((Object)specification.getListTypeDefinitionIds(), (long[])new long[]{GetterUtil.getLong((Object)specification.getListTypeDefinitionId())}), LanguageUtils.getLocalizedMap((Map)specification.getTitle()), LanguageUtils.getLocalizedMap((Map)specification.getDescription()), GetterUtil.getBoolean((Object)specification.getFacetable()), specificationKey, GetterUtil.getDouble((Object)specification.getPriority()), true, this._serviceContextHelper.getServiceContext());
        return this._toSpecification(cpSpecificationOption.getCPSpecificationOptionId());
    }

    private long _getCPOptionCategoryId(Specification specification) {
        OptionCategory optionCategory = specification.getOptionCategory();
        if (optionCategory == null) {
            return 0L;
        }
        return optionCategory.getId();
    }

    private Specification _toSpecification(Long cpSpecificationOptionId) throws Exception {
        return (Specification)this._specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpSpecificationOptionId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private CPSpecificationOption _updateSpecification(CPSpecificationOption cpSpecificationOption, Specification specification) throws PortalException {
        Map titleMap;
        Map descriptionMap = specification.getDescription();
        if (descriptionMap == null) {
            descriptionMap = LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getDescriptionMap());
        }
        long[] listTypeDefinitionIds = GetterUtil.getLongValues((Object)specification.getListTypeDefinitionIds(), (long[])this.transformToLongArray(cpSpecificationOption.getListTypeDefinitions(), ListTypeDefinitionModel::getListTypeDefinitionId));
        if (specification.getListTypeDefinitionIds() == null) {
            long listTypeDefinitionId = GetterUtil.getLong((Object)specification.getListTypeDefinitionId());
            List listTypeDefinitions = cpSpecificationOption.getListTypeDefinitions();
            if (!listTypeDefinitions.isEmpty()) {
                ListTypeDefinition listTypeDefinition = (ListTypeDefinition)listTypeDefinitions.get(0);
                listTypeDefinitionId = GetterUtil.getLong((Object)specification.getListTypeDefinitionId(), (long)listTypeDefinition.getListTypeDefinitionId());
            }
            listTypeDefinitionIds = new long[]{listTypeDefinitionId};
        }
        if ((titleMap = specification.getTitle()) == null) {
            titleMap = LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getTitleMap());
        }
        return this._cpSpecificationOptionService.updateCPSpecificationOption(GetterUtil.getString((String)specification.getExternalReferenceCode(), (String)cpSpecificationOption.getExternalReferenceCode()), cpSpecificationOption.getCPSpecificationOptionId(), GetterUtil.getLong((Object)cpSpecificationOption.getCPOptionCategoryId(), (long)this._getCPOptionCategoryId(specification)), listTypeDefinitionIds, LanguageUtils.getLocalizedMap((Map)titleMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), GetterUtil.getBoolean((Object)specification.getFacetable(), (boolean)cpSpecificationOption.isFacetable()), GetterUtil.getString((String)specification.getKey(), (String)cpSpecificationOption.getKey()), GetterUtil.getDouble((Object)specification.getPriority(), (double)cpSpecificationOption.getPriority()), GetterUtil.getBoolean((Object)specification.getVisible(), (boolean)cpSpecificationOption.isVisible()), this._serviceContextHelper.getServiceContext());
    }
}

