/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseRelatedProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.RelatedProductUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.RelatedProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/related-product.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={RelatedProductResource.class})
public class RelatedProductResourceImpl
extends BaseRelatedProductResourceImpl {
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.RelatedProductDTOConverter)")
    private DTOConverter<CPDefinitionLink, RelatedProduct> _relatedProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteRelatedProduct(Long id) throws Exception {
        this._cpDefinitionLinkService.deleteCPDefinitionLink(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<RelatedProduct> getProductByExternalReferenceCodeRelatedProductsPage(String externalReferenceCode, String type, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._getRelatedProductPage(cpDefinition, type, pagination);
    }

    @Override
    @NestedField(parentClass=Product.class, value="relatedProducts")
    public Page<RelatedProduct> getProductIdRelatedProductsPage(@NestedFieldId(value="productId") Long id, String type, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._getRelatedProductPage(cpDefinition, type, pagination);
    }

    @Override
    public RelatedProduct getRelatedProduct(Long id) throws Exception {
        return this._toRelatedProduct(GetterUtil.getLong((Object)id));
    }

    @Override
    public RelatedProduct postProductByExternalReferenceCodeRelatedProduct(String externalReferenceCode, RelatedProduct relatedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateRelatedProduct(cpDefinition, relatedProduct);
    }

    @Override
    public RelatedProduct postProductIdRelatedProduct(Long id, RelatedProduct relatedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._addOrUpdateRelatedProduct(cpDefinition, relatedProduct);
    }

    private RelatedProduct _addOrUpdateRelatedProduct(CPDefinition cpDefinition, RelatedProduct relatedProduct) throws Exception {
        CPDefinitionLink cpDefinitionLink = RelatedProductUtil.addOrUpdateCPDefinitionLink(this._cpDefinitionLinkService, this._cpDefinitionService, relatedProduct, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        return this._toRelatedProduct(cpDefinitionLink.getCPDefinitionLinkId());
    }

    private Page<RelatedProduct> _getRelatedProductPage(CPDefinition cpDefinition, String type, Pagination pagination) throws Exception {
        int totalCount;
        List cpDefinitionLinks;
        if (Validator.isNull((String)type)) {
            cpDefinitionLinks = this._cpDefinitionLinkService.getCPDefinitionLinks(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
            totalCount = this._cpDefinitionLinkService.getCPDefinitionLinksCount(cpDefinition.getCPDefinitionId());
        } else {
            cpDefinitionLinks = this._cpDefinitionLinkService.getCPDefinitionLinks(cpDefinition.getCPDefinitionId(), type, pagination.getStartPosition(), pagination.getEndPosition(), null);
            totalCount = this._cpDefinitionLinkService.getCPDefinitionLinksCount(cpDefinition.getCPDefinitionId(), type);
        }
        return Page.of(this._toRelatedProducts(cpDefinitionLinks), (Pagination)pagination, (long)totalCount);
    }

    private RelatedProduct _toRelatedProduct(Long cpDefinitionLinkId) throws Exception {
        return (RelatedProduct)this._relatedProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionLinkId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private List<RelatedProduct> _toRelatedProducts(List<CPDefinitionLink> cpDefinitionLinks) throws Exception {
        return this.transform(cpDefinitionLinks, cpDefinitionLink -> this._toRelatedProduct(cpDefinitionLink.getCPDefinitionLinkId()));
    }
}

