/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.account.service.AccountGroupRelLocalService;
import com.liferay.account.service.AccountGroupRelService;
import com.liferay.account.service.AccountGroupService;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceEntryService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.configuration.CProductVersionConfiguration;
import com.liferay.commerce.product.exception.CPDefinitionProductTypeNameException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCatalogException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPConfigurationEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.commerce.product.service.CPConfigurationEntryService;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.service.CPInstanceUnitOfMeasureService;
import com.liferay.commerce.product.service.CPOptionCategoryService;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeRegistry;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramPinService;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramSettingService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Diagram;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Pin;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductAccountGroup;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductChannel;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOptionValue;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SkuUnitOfMeasure;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.ProductEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.AttachmentUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.DiagramUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.MappedProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.PinUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductOptionValueUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductShippingConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSpecificationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSubscriptionConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductTaxConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductVirtualSettingsUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.RelatedProductUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUnitOfMeasureUtil;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.SkuUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductResource;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.ExpandoUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.headless.common.spi.odata.entity.EntityFieldsUtil;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.expando.ExpandoBridgeIndexer;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.upload.UniqueFileNameProvider;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductResource.class})
public class ProductResourceImpl
extends BaseProductResourceImpl {
    @Reference
    private AccountGroupRelLocalService _accountGroupRelLocalService;
    @Reference
    private AccountGroupRelService _accountGroupRelService;
    @Reference
    private AccountGroupService _accountGroupService;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceEntryService _commercePriceEntryService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private CPConfigurationEntryService _cpConfigurationEntryService;
    @Reference
    private CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;
    @Reference
    private CPDefinitionOptionValueRelService _cpDefinitionOptionValueRelService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPDefinitionVirtualSettingService _cpDefinitionVirtualSettingService;
    @Reference
    private CPDVirtualSettingFileEntryService _cpdVirtualSettingFileEntryService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CPInstanceUnitOfMeasureService _cpInstanceUnitOfMeasureService;
    @Reference
    private CPOptionCategoryService _cpOptionCategoryService;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private CPTypeRegistry _cpTypeRegistry;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;
    @Reference
    private CSDiagramPinService _csDiagramPinService;
    @Reference
    private CSDiagramSettingService _csDiagramSettingService;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ExpandoBridgeIndexer _expandoBridgeIndexer;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductDTOConverter)")
    private DTOConverter<CPDefinition, Product> _productDTOConverter;
    @Reference
    private RepositoryLocalService _repositoryLocalService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    public void delete(Collection<Product> products, Map<String, Serializable> parameters) throws Exception {
        for (Product product : products) {
            this.deleteProduct(product.getProductId());
        }
    }

    @Override
    public void deleteProduct(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void deleteProductByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void deleteProductByExternalReferenceCodeByVersion(String externalReferenceCode, Integer version) throws Exception {
        CProduct cProduct = this._cProductLocalService.fetchCProductByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cProduct == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(cProduct.getCProductId(), version.intValue());
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void deleteProductByVersion(Long id, Integer version) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(id.longValue(), version.intValue());
        this._cpDefinitionService.deleteCPDefinition(cpDefinition.getCPDefinitionId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return new ProductEntityModel(EntityFieldsUtil.getEntityFields((long)this._portal.getClassNameId(CPDefinition.class.getName()), (long)this.contextCompany.getCompanyId(), (ExpandoBridgeIndexer)this._expandoBridgeIndexer, (ExpandoColumnLocalService)this._expandoColumnLocalService, (ExpandoTableLocalService)this._expandoTableLocalService));
    }

    @Override
    public Product getProduct(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product getProductByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product getProductByExternalReferenceCodeByVersion(String externalReferenceCode, Integer version) throws Exception {
        CProduct cProduct = this._cProductLocalService.fetchCProductByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cProduct == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(cProduct.getCProductId(), version.intValue());
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product getProductByVersion(Long id, Integer version) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCProductCPDefinition(id.longValue(), version.intValue());
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Page<Product> getProductsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getProductsPage(this.contextCompany.getCompanyId(), search, filter, pagination, sorts, (UnsafeFunction<Document, Product, Exception>)((UnsafeFunction)document -> this._toProduct(GetterUtil.getLong((String)document.get("entryClassPK")))), this.contextAcceptLanguage.getPreferredLocale());
    }

    @Override
    public Response patchProduct(Long id, Product product) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        this._updateProduct(cpDefinition, product);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductByExternalReferenceCode(String externalReferenceCode, Product product) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        int productStatus = GetterUtil.getInteger((Object)product.getProductStatus());
        if (productStatus == 2) {
            serviceContext.setWorkflowAction(2);
        }
        this._updateProduct(cpDefinition, product);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Product postProduct(Product product) throws Exception {
        CPDefinition cpDefinition = this._addOrUpdateProduct(product.getExternalReferenceCode(), product);
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product postProductByExternalReferenceCodeClone(String externalReferenceCode, String catalogExternalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (catalogExternalReferenceCode != null) {
            commerceCatalog = this._commerceCatalogLocalService.fetchCommerceCatalogByExternalReferenceCode(catalogExternalReferenceCode, this.contextCompany.getCompanyId());
        }
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException();
        }
        cpDefinition = this._cpDefinitionService.copyCPDefinition(cpDefinition.getCPDefinitionId(), commerceCatalog.getGroupId(), 2);
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product postProductClone(Long id, Long catalogId) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (catalogId != null) {
            commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(catalogId.longValue());
        }
        cpDefinition = this._cpDefinitionService.cloneCPDefinition(cpDefinition.getCPDefinitionId(), commerceCatalog.getGroupId(), this._serviceContextHelper.getServiceContext(commerceCatalog.getGroupId()));
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Product putProductByExternalReferenceCode(String externalReferenceCode, Product product) throws Exception {
        CPDefinition cpDefinition = this._addOrUpdateProduct(externalReferenceCode, product);
        return this._toProduct(cpDefinition.getCPDefinitionId());
    }

    @Override
    public void update(Collection<Product> products, Map<String, Serializable> parameters) throws Exception {
        for (Product product : products) {
            this.patchProduct(product.getProductId(), product);
        }
    }

    private CPDefinition _addOrUpdateProduct(String externalReferenceCode, Product product) throws Exception {
        Map expando;
        int productStatus;
        CommerceCatalog commerceCatalog = null;
        if (product.getCatalogId() != null) {
            commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalog(product.getCatalogId().longValue());
        } else if (product.getCatalogExternalReferenceCode() != null) {
            commerceCatalog = this._commerceCatalogLocalService.getCommerceCatalogByExternalReferenceCode(product.getCatalogExternalReferenceCode(), this.contextCompany.getCompanyId());
        }
        if (commerceCatalog == null) {
            throw new NoSuchCatalogException();
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(commerceCatalog.getGroupId());
        String[] assetTagNames = new String[]{};
        if (product.getTags() != null) {
            assetTagNames = product.getTags();
        }
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(CPDefinition.class.getName(), product.getCustomFields()));
        DateConfig displayDateConfig = DateConfig.toDisplayDateConfig((Date)product.getDisplayDate(), (TimeZone)serviceContext.getTimeZone());
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)product.getExpirationDate(), (TimeZone)serviceContext.getTimeZone());
        ProductShippingConfiguration productShippingConfiguration = this._getProductShippingConfiguration(product);
        ProductSubscriptionConfiguration productSubscriptionConfiguration = product.getSubscriptionConfiguration();
        boolean deliverySubscriptionEnable = false;
        int deliverySubscriptionLength = 1;
        long deliverySubscriptionMaxSubscriptionCycles = 0L;
        UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties = null;
        String deliverySubscriptionTypeValue = "";
        boolean subscriptionEnable = false;
        int subscriptionLength = 1;
        long subscriptionMaxSubscriptionCycles = 0L;
        UnicodeProperties subscriptionTypeSettingsUnicodeProperties = null;
        String subscriptionTypeValue = "";
        if (productSubscriptionConfiguration != null) {
            ProductSubscriptionConfiguration.SubscriptionType subscriptionType;
            ProductSubscriptionConfiguration.DeliverySubscriptionType deliverySubscriptionType;
            deliverySubscriptionEnable = GetterUtil.getBoolean((Object)productSubscriptionConfiguration.getDeliverySubscriptionEnable(), (boolean)deliverySubscriptionEnable);
            deliverySubscriptionLength = GetterUtil.getInteger((Object)productSubscriptionConfiguration.getDeliverySubscriptionLength(), (int)deliverySubscriptionLength);
            deliverySubscriptionMaxSubscriptionCycles = GetterUtil.getLong((Object)productSubscriptionConfiguration.getDeliverySubscriptionNumberOfLength(), (long)deliverySubscriptionMaxSubscriptionCycles);
            if (Validator.isNotNull((Object)productSubscriptionConfiguration.getDeliverySubscriptionTypeSettings())) {
                deliverySubscriptionTypeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((Map)productSubscriptionConfiguration.getDeliverySubscriptionTypeSettings(), (boolean)true).build();
            }
            if ((deliverySubscriptionType = productSubscriptionConfiguration.getDeliverySubscriptionType()) != null) {
                deliverySubscriptionTypeValue = deliverySubscriptionType.getValue();
            }
            subscriptionEnable = GetterUtil.getBoolean((Object)productSubscriptionConfiguration.getEnable(), (boolean)subscriptionEnable);
            subscriptionLength = GetterUtil.getInteger((Object)productSubscriptionConfiguration.getLength(), (int)subscriptionLength);
            subscriptionMaxSubscriptionCycles = GetterUtil.getLong((Object)productSubscriptionConfiguration.getNumberOfLength(), (long)subscriptionMaxSubscriptionCycles);
            if (Validator.isNotNull((Object)productSubscriptionConfiguration.getSubscriptionTypeSettings())) {
                subscriptionTypeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((Map)productSubscriptionConfiguration.getSubscriptionTypeSettings(), (boolean)true).build();
            }
            if ((subscriptionType = productSubscriptionConfiguration.getSubscriptionType()) != null) {
                subscriptionTypeValue = subscriptionType.getValue();
            }
        }
        ProductTaxConfiguration productTaxConfiguration = this._getProductTaxConfiguration(product);
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        Category[] categories = product.getCategories();
        if (categories != null) {
            serviceContext.setAssetCategoryIds(this.transformToLongArray(Arrays.asList(categories), category -> {
                if (Validator.isNull((String)category.getExternalReferenceCode())) {
                    return category.getId();
                }
                AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(category.getExternalReferenceCode(), this.contextCompany.getGroupId());
                if (assetCategory == null) {
                    return null;
                }
                return assetCategory.getCategoryId();
            }));
        } else if (cpDefinition != null) {
            serviceContext.setAssetCategoryIds(this._assetCategoryLocalService.getCategoryIds(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()));
        }
        Map nameMap = product.getName();
        if (cpDefinition != null && nameMap == null) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
        }
        Map shortDescriptionMap = product.getShortDescription();
        if (cpDefinition != null && shortDescriptionMap == null) {
            shortDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
        }
        Map descriptionMap = product.getDescription();
        if (cpDefinition != null && descriptionMap == null) {
            descriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
        }
        Map urlTitleMap = product.getUrls();
        if (cpDefinition != null && urlTitleMap == null) {
            urlTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getUrlTitleMap());
        }
        Map metaTitleMap = product.getMetaTitle();
        if (cpDefinition != null && metaTitleMap == null) {
            metaTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
        }
        Map metaDescriptionMap = product.getMetaDescription();
        if (cpDefinition != null && metaDescriptionMap == null) {
            metaDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
        }
        Map metaKeywordsMap = product.getMetaKeyword();
        if (cpDefinition != null && metaKeywordsMap == null) {
            metaKeywordsMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
        }
        boolean ignoreSKUCombinations = true;
        if (cpDefinition != null) {
            ignoreSKUCombinations = cpDefinition.isIgnoreSKUCombinations();
        }
        if ((productStatus = GetterUtil.getInteger((Object)product.getProductStatus())) != 0) {
            serviceContext.setWorkflowAction(2);
        }
        int originalWorkflowAction = serviceContext.getWorkflowAction();
        cpDefinition = this._cpDefinitionService.addOrUpdateCPDefinition(externalReferenceCode, commerceCatalog.getGroupId(), LanguageUtils.getLocalizedMap((Map)nameMap), LanguageUtils.getLocalizedMap((Map)shortDescriptionMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), LanguageUtils.getLocalizedMap((Map)urlTitleMap), LanguageUtils.getLocalizedMap((Map)metaTitleMap), LanguageUtils.getLocalizedMap((Map)metaDescriptionMap), LanguageUtils.getLocalizedMap((Map)metaKeywordsMap), product.getProductType(), ignoreSKUCombinations, GetterUtil.getBoolean((Object)productShippingConfiguration.getShippable(), (boolean)true), GetterUtil.getBoolean((Object)productShippingConfiguration.getFreeShipping(), (boolean)true), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippingSeparately(), (boolean)true), GetterUtil.getDouble((Object)productShippingConfiguration.getShippingExtraPrice()), GetterUtil.getDouble((Object)productShippingConfiguration.getWidth()), GetterUtil.getDouble((Object)productShippingConfiguration.getHeight()), GetterUtil.getDouble((Object)productShippingConfiguration.getDepth()), GetterUtil.getDouble((Object)productShippingConfiguration.getWeight()), GetterUtil.getLong((Object)productTaxConfiguration.getId()), ProductUtil.isTaxExempt(null, productTaxConfiguration), false, null, true, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.getBoolean((Object)product.getNeverExpire(), (boolean)true), product.getDefaultSku(), subscriptionEnable, subscriptionLength, subscriptionTypeValue, subscriptionTypeSettingsUnicodeProperties, subscriptionMaxSubscriptionCycles, deliverySubscriptionEnable, deliverySubscriptionLength, deliverySubscriptionTypeValue, deliverySubscriptionTypeSettingsUnicodeProperties, deliverySubscriptionMaxSubscriptionCycles, productStatus, serviceContext);
        if (product.getActive() != null && !product.getActive().booleanValue()) {
            HashMap workflowContext = new HashMap();
            this._cpDefinitionService.updateStatus(cpDefinition.getCPDefinitionId(), 5, serviceContext, workflowContext);
        }
        if ((expando = product.getExpando()) != null && !expando.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CPDefinition.class, (long)cpDefinition.getPrimaryKey(), (Map)expando);
        }
        int currentWorkflowAction = serviceContext.getWorkflowAction();
        serviceContext.setWorkflowAction(originalWorkflowAction);
        this._updateNestedResources(product, cpDefinition, serviceContext);
        serviceContext.setWorkflowAction(currentWorkflowAction);
        return cpDefinition;
    }

    private Map<String, Map<String, String>> _getActions(CPDefinition cpDefinition) {
        return HashMapBuilder.put((Object)"delete", () -> {
            Map<String, String> action = this.addAction("UPDATE", cpDefinition.getCPDefinitionId(), "deleteProduct", this._cpDefinitionModelResourcePermission);
            if (action == null) {
                return null;
            }
            String href = action.get("href");
            action.put("href", StringUtil.replace((String)href, (String)String.valueOf(cpDefinition.getCPDefinitionId()), (String)String.valueOf(cpDefinition.getCProductId())));
            return action;
        }).put((Object)"get", () -> {
            Map<String, String> action = this.addAction("VIEW", cpDefinition.getCPDefinitionId(), "getProduct", this._cpDefinitionModelResourcePermission);
            if (action == null) {
                return null;
            }
            String href = action.get("href");
            action.put("href", StringUtil.replace((String)href, (String)String.valueOf(cpDefinition.getCPDefinitionId()), (String)String.valueOf(cpDefinition.getCProductId())));
            return action;
        }).put((Object)"update", () -> {
            Map<String, String> action = this.addAction("UPDATE", cpDefinition.getCPDefinitionId(), "patchProduct", this._cpDefinitionModelResourcePermission);
            if (action == null) {
                return null;
            }
            String href = action.get("href");
            action.put("href", StringUtil.replace((String)href, (String)String.valueOf(cpDefinition.getCPDefinitionId()), (String)String.valueOf(cpDefinition.getCProductId())));
            return action;
        }).build();
    }

    private CPDefinition _getCPDefinition(CPDefinition cpDefinition, ServiceContext serviceContext) throws Exception {
        CProductVersionConfiguration cProductVersionConfiguration;
        if (!cpDefinition.isDraft() && serviceContext.getWorkflowAction() == 2 && (cProductVersionConfiguration = (CProductVersionConfiguration)this._configurationProvider.getConfiguration(CProductVersionConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(cpDefinition.getCompanyId(), CProductVersionConfiguration.class.getName()))).enabled()) {
            for (CPDefinition cProductCPDefinition : this._cpDefinitionService.getCProductCPDefinitions(cpDefinition.getCProductId(), 2, -1, -1)) {
                this._cpDefinitionService.updateStatus(cProductCPDefinition.getCPDefinitionId(), 6, serviceContext, Collections.emptyMap());
            }
            cpDefinition = this._cpDefinitionService.copyCPDefinition(cpDefinition.getCPDefinitionId(), cpDefinition.getGroupId(), 2);
        }
        return cpDefinition;
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(String className, CustomField[] customFields) {
        HashMap expandoBridgeAttributes = CustomFieldsUtil.toMap((String)className, (long)this.contextCompany.getCompanyId(), (CustomField[])customFields, (Locale)this.contextAcceptLanguage.getPreferredLocale());
        if (expandoBridgeAttributes == null) {
            expandoBridgeAttributes = new HashMap();
        }
        return expandoBridgeAttributes;
    }

    private ProductShippingConfiguration _getProductShippingConfiguration(Product product) {
        ProductShippingConfiguration productShippingConfiguration = product.getShippingConfiguration();
        if (productShippingConfiguration != null) {
            return productShippingConfiguration;
        }
        return new ProductShippingConfiguration();
    }

    private ProductShippingConfiguration _getProductShippingConfiguration(ProductConfiguration productConfiguration) {
        ProductShippingConfiguration productShippingConfiguration = productConfiguration.getProductShippingConfiguration();
        if (productShippingConfiguration == null) {
            return new ProductShippingConfiguration();
        }
        return productShippingConfiguration;
    }

    private Page<Product> _getProductsPage(long companyId, String search, Filter filter, Pagination pagination, Sort[] sorts, UnsafeFunction<Document, Product, Exception> transformUnsafeFunction, Locale preferredLocale) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPDefinition.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(companyId);
            long[] commerceCatalogGroupIds = this.transformToLongArray(this._commerceCatalogLocalService.search(companyId), CommerceCatalog::getGroupId);
            if (commerceCatalogGroupIds != null && commerceCatalogGroupIds.length > 0) {
                searchContext.setGroupIds(commerceCatalogGroupIds);
            }
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            if (preferredLocale != null) {
                searchContext.setLocale(preferredLocale);
            }
        }, (Sort[])sorts, transformUnsafeFunction);
    }

    private ProductTaxConfiguration _getProductTaxConfiguration(Product product) {
        ProductTaxConfiguration productTaxConfiguration = product.getTaxConfiguration();
        if (productTaxConfiguration != null) {
            return productTaxConfiguration;
        }
        return new ProductTaxConfiguration();
    }

    private ProductTaxConfiguration _getProductTaxConfiguration(ProductConfiguration productConfiguration) {
        ProductTaxConfiguration productTaxConfiguration = productConfiguration.getProductTaxConfiguration();
        if (productTaxConfiguration == null) {
            return new ProductTaxConfiguration();
        }
        return productTaxConfiguration;
    }

    private boolean _isTaxable(ProductTaxConfiguration productTaxConfiguration) {
        if (productTaxConfiguration.getTaxable() == null) {
            return true;
        }
        return productTaxConfiguration.getTaxable();
    }

    private Product _toProduct(Long cpDefinitionId) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cpDefinitionId.longValue());
        return (Product)this._productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpDefinition), this._dtoConverterRegistry, (Object)cpDefinitionId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private CPDefinition _updateNestedResources(Product product, CPDefinition cpDefinition, ServiceContext serviceContext) throws Exception {
        ProductVirtualSettings productVirtualSettings;
        ProductAccountGroup[] productAccountGroups;
        Attachment[] attachments;
        Attachment[] images;
        Sku[] skus;
        RelatedProduct[] relatedProducts;
        ProductOption[] productOptions;
        ProductSpecification[] productSpecifications;
        ProductSubscriptionConfiguration productSubscriptionConfiguration;
        ProductShippingConfiguration productShippingConfiguration;
        ProductTaxConfiguration productTaxConfiguration;
        serviceContext.setExpandoBridgeAttributes(null);
        ProductConfiguration productConfiguration = product.getProductConfiguration();
        if (productConfiguration != null) {
            CPConfigurationEntry masterCPConfigurationEntry = cpDefinition.fetchMasterCPConfigurationEntry();
            if (masterCPConfigurationEntry != null) {
                ProductShippingConfiguration productShippingConfiguration2 = this._getProductShippingConfiguration(productConfiguration);
                productTaxConfiguration = this._getProductTaxConfiguration(productConfiguration);
                this._cpConfigurationEntryService.updateCPConfigurationEntry(GetterUtil.getString((String)productConfiguration.getExternalReferenceCode(), (String)masterCPConfigurationEntry.getExternalReferenceCode()), masterCPConfigurationEntry.getCPConfigurationEntryId(), GetterUtil.getLong((Object)productTaxConfiguration.getId(), (long)masterCPConfigurationEntry.getCPTaxCategoryId()), ProductConfigurationUtil.getAllowedOrderQuantities(productConfiguration.getAllowedOrderQuantities(), masterCPConfigurationEntry.getAllowedOrderQuantities()), GetterUtil.getBoolean((Object)productConfiguration.getAllowBackOrder(), (boolean)masterCPConfigurationEntry.isBackOrders()), GetterUtil.getLong((Object)productConfiguration.getAvailabilityEstimateId(), (long)masterCPConfigurationEntry.getCommerceAvailabilityEstimateId()), GetterUtil.getString((String)productConfiguration.getInventoryEngine(), (String)masterCPConfigurationEntry.getCPDefinitionInventoryEngine()), GetterUtil.getDouble((Object)productShippingConfiguration2.getDepth(), (double)masterCPConfigurationEntry.getDepth()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayAvailability(), (boolean)masterCPConfigurationEntry.isDisplayAvailability()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayStockQuantity(), (boolean)masterCPConfigurationEntry.isDisplayStockQuantity()), GetterUtil.getBoolean((Object)productShippingConfiguration2.getFreeShipping(), (boolean)masterCPConfigurationEntry.isFreeShipping()), GetterUtil.getDouble((Object)productShippingConfiguration2.getHeight(), (double)masterCPConfigurationEntry.getHeight()), GetterUtil.getString((String)productConfiguration.getLowStockAction(), (String)masterCPConfigurationEntry.getLowStockActivity()), BigDecimalUtil.get((Object)productConfiguration.getMaxOrderQuantity(), (BigDecimal)masterCPConfigurationEntry.getMaxOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinOrderQuantity(), (BigDecimal)masterCPConfigurationEntry.getMinOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinStockQuantity(), (BigDecimal)masterCPConfigurationEntry.getMinStockQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMultipleOrderQuantity(), (BigDecimal)masterCPConfigurationEntry.getMultipleOrderQuantity()), GetterUtil.getBoolean((Object)productConfiguration.getPurchasable(), (boolean)masterCPConfigurationEntry.isPurchasable()), GetterUtil.getBoolean((Object)productShippingConfiguration2.getShippable(), (boolean)masterCPConfigurationEntry.isShippable()), GetterUtil.getDouble((Object)productShippingConfiguration2.getShippingExtraPrice(), (double)masterCPConfigurationEntry.getShippingExtraPrice()), GetterUtil.getBoolean((Object)productShippingConfiguration2.getShippingSeparately(), (boolean)masterCPConfigurationEntry.isShipSeparately()), GetterUtil.getBoolean((Object)(!this._isTaxable(productTaxConfiguration) ? 1 : 0), (boolean)masterCPConfigurationEntry.isTaxExempt()), GetterUtil.getBoolean((Object)productConfiguration.getVisible(), (boolean)masterCPConfigurationEntry.isVisible()), GetterUtil.getDouble((Object)productShippingConfiguration2.getWeight(), (double)masterCPConfigurationEntry.getWeight()), GetterUtil.getDouble((Object)productShippingConfiguration2.getWidth(), (double)masterCPConfigurationEntry.getWidth()));
            }
            ProductConfigurationUtil.updateCPDefinitionInventory(this._cpDefinitionInventoryService, productConfiguration, cpDefinition.getCPDefinitionId());
            ProductConfigurationUtil.updateCPDAvailabilityEstimate(this._cpdAvailabilityEstimateService, productConfiguration, cpDefinition.getCPDefinitionId());
        }
        if ((productShippingConfiguration = product.getShippingConfiguration()) != null) {
            cpDefinition = ProductShippingConfigurationUtil.updateCPDefinitionShippingInfo(this._cpDefinitionService, productShippingConfiguration, cpDefinition, serviceContext);
        }
        if ((productSubscriptionConfiguration = product.getSubscriptionConfiguration()) != null) {
            cpDefinition = ProductSubscriptionConfigurationUtil.updateCPDefinitionSubscriptionInfo(this._cpDefinitionService, productSubscriptionConfiguration, cpDefinition, serviceContext);
        }
        if ((productTaxConfiguration = product.getTaxConfiguration()) != null) {
            cpDefinition = ProductTaxConfigurationUtil.updateCPDefinitionTaxCategoryInfo(this._cpDefinitionService, productTaxConfiguration, cpDefinition);
        }
        if ((productSpecifications = product.getProductSpecifications()) != null) {
            this._cpDefinitionSpecificationOptionValueService.deleteCPDefinitionSpecificationOptionValues(cpDefinition.getCPDefinitionId());
            for (ProductSpecification productSpecification : productSpecifications) {
                ProductSpecificationUtil.addCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, this._cpOptionCategoryService, this._cpSpecificationOptionService, cpDefinition.getCPDefinitionId(), productSpecification, serviceContext);
            }
        }
        if ((productOptions = product.getProductOptions()) != null) {
            for (ProductOption productOption : productOptions) {
                serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(CPDefinitionOptionRel.class.getName(), productOption.getCustomFields()));
                CPDefinitionOptionRel cpDefinitionOptionRel = ProductOptionUtil.addOrUpdateCPDefinitionOptionRel(this._cpDefinitionOptionRelService, this._cpOptionService, productOption, cpDefinition.getCPDefinitionId(), serviceContext);
                serviceContext.setExpandoBridgeAttributes(null);
                ProductOptionValue[] productOptionValues = productOption.getProductOptionValues();
                if (productOptionValues == null) continue;
                for (ProductOptionValue productOptionValue : productOptionValues) {
                    ProductOptionValueUtil.addOrUpdateCPDefinitionOptionValueRel(this._cpDefinitionOptionValueRelService, this._cpInstanceService, productOptionValue, cpDefinitionOptionRel.getCPDefinitionOptionRelId(), serviceContext);
                }
            }
        }
        if ((relatedProducts = product.getRelatedProducts()) != null) {
            for (RelatedProduct relatedProduct : relatedProducts) {
                RelatedProductUtil.addOrUpdateCPDefinitionLink(this._cpDefinitionLinkService, this._cpDefinitionService, relatedProduct, cpDefinition.getCPDefinitionId(), this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
            }
        }
        if ((skus = product.getSkus()) != null) {
            for (Sku sku : skus) {
                serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(CPInstance.class.getName(), sku.getCustomFields()));
                CPInstance cpInstance = SkuUtil.addOrUpdateCPInstance(this._cpInstanceService, sku, cpDefinition, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, serviceContext);
                serviceContext.setExpandoBridgeAttributes(null);
                if (ArrayUtil.isEmpty((Object[])sku.getSkuUnitOfMeasures())) {
                    SkuUtil.updateCommercePriceEntries(this._commercePriceEntryLocalService, this._commercePriceListLocalService, this._configurationProvider, cpInstance, (BigDecimal)GetterUtil.get((Object)sku.getPrice(), (Number)cpInstance.getPrice()), (BigDecimal)GetterUtil.get((Object)sku.getPromoPrice(), (Number)cpInstance.getPromoPrice()), "", serviceContext);
                    continue;
                }
                for (SkuUnitOfMeasure skuUnitOfMeasure : sku.getSkuUnitOfMeasures()) {
                    SkuUnitOfMeasureUtil.addOrUpdateCPInstanceUnitOfMeasure(this._cpInstanceUnitOfMeasureService, this._commercePriceEntryService, this._commercePriceListLocalService, cpInstance, skuUnitOfMeasure, serviceContext);
                }
            }
        }
        if ((images = product.getImages()) != null) {
            for (Attachment attachment : images) {
                serviceContext.setAssetTagNames(attachment.getTags());
                serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(CPAttachmentFileEntry.class.getName(), attachment.getCustomFields()));
                AttachmentUtil.addOrUpdateCPAttachmentFileEntry(cpDefinition.getGroupId(), this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._dlAppLocalService, this._dlFileEntryModelResourcePermission, this._groupLocalService, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), 0, serviceContext);
            }
        }
        if ((attachments = product.getAttachments()) != null) {
            for (Attachment attachment : attachments) {
                serviceContext.setAssetTagNames(attachment.getTags());
                serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(CPAttachmentFileEntry.class.getName(), attachment.getCustomFields()));
                AttachmentUtil.addOrUpdateCPAttachmentFileEntry(cpDefinition.getGroupId(), this._cpAttachmentFileEntryService, this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._dlAppLocalService, this._dlFileEntryModelResourcePermission, this._groupLocalService, this._uniqueFileNameProvider, attachment, this._classNameLocalService.getClassNameId(cpDefinition.getModelClassName()), cpDefinition.getCPDefinitionId(), 1, serviceContext);
            }
        }
        this._cpDefinitionService.updateCPDefinitionChannelFilter(cpDefinition.getCPDefinitionId(), GetterUtil.getBoolean((Object)product.getProductChannelFilter(), (boolean)cpDefinition.isChannelFilterEnabled()));
        ProductChannel[] productChannels = product.getProductChannels();
        if (productChannels != null) {
            this._commerceChannelRelService.deleteCommerceChannelRels(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
            for (ProductChannel productChannel : productChannels) {
                CommerceChannel commerceChannel = this._commerceChannelService.fetchCommerceChannelByExternalReferenceCode(GetterUtil.getString((String)productChannel.getExternalReferenceCode()), this.contextCompany.getCompanyId());
                if (commerceChannel == null && (commerceChannel = this._commerceChannelService.fetchCommerceChannel(GetterUtil.getLong((Object)productChannel.getChannelId()))) == null) continue;
                this._commerceChannelRelService.addCommerceChannelRel(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), commerceChannel.getCommerceChannelId(), serviceContext);
            }
        }
        if ((productAccountGroups = product.getProductAccountGroups()) != null) {
            this._accountGroupRelLocalService.deleteAccountGroupRels(CPDefinition.class.getName(), new long[]{cpDefinition.getCPDefinitionId()});
            for (ProductAccountGroup productAccountGroup : productAccountGroups) {
                MappedProduct[] accountGroup = this._accountGroupService.fetchAccountGroupByExternalReferenceCode(GetterUtil.getString((String)productAccountGroup.getExternalReferenceCode()), this.contextCompany.getCompanyId());
                if (accountGroup == null && (accountGroup = this._accountGroupService.fetchAccountGroup(GetterUtil.getLong((Object)productAccountGroup.getAccountGroupId()))) == null) continue;
                this._accountGroupRelService.addAccountGroupRel(accountGroup.getAccountGroupId(), CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
            }
        }
        this._cpDefinitionService.updateCPDefinitionAccountGroupFilter(cpDefinition.getCPDefinitionId(), GetterUtil.getBoolean((Object)product.getProductAccountGroupFilter(), (boolean)cpDefinition.isAccountGroupFilterEnabled()));
        CPType cpType = this._cpTypeRegistry.getCPType(cpDefinition.getProductTypeName());
        if (cpType == null) {
            return cpDefinition;
        }
        Diagram diagram = product.getDiagram();
        MappedProduct[] mappedProducts = product.getMappedProducts();
        Pin[] pins = product.getPins();
        if (diagram != null || mappedProducts != null || pins != null) {
            if ("diagram".equals(cpType.getName())) {
                if (diagram != null) {
                    DiagramUtil.addOrUpdateCSDiagramSetting(this.contextCompany.getCompanyId(), this._cpAttachmentFileEntryService, cpDefinition.getCPDefinitionId(), this._cpDefinitionOptionRelService, this._cpDefinitionOptionValueRelService, this._cpOptionService, this._csDiagramSettingService, diagram, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this._serviceContextHelper, this._uniqueFileNameProvider);
                }
                if (mappedProducts != null) {
                    this._csDiagramEntryService.deleteCSDiagramEntries(cpDefinition.getCPDefinitionId());
                    for (MappedProduct mappedProduct : mappedProducts) {
                        MappedProductUtil.addOrUpdateCSDiagramEntry(this.contextCompany.getCompanyId(), cpDefinition.getCPDefinitionId(), this._cpDefinitionService, this._cpInstanceService, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
                    }
                }
                if (pins != null) {
                    this._csDiagramPinService.deleteCSDiagramPins(cpDefinition.getCPDefinitionId());
                    for (MappedProduct mappedProduct : pins) {
                        PinUtil.addOrUpdateCSDiagramPin(cpDefinition.getCPDefinitionId(), this._csDiagramPinService, (Pin)mappedProduct);
                    }
                }
            } else {
                throw new CPDefinitionProductTypeNameException();
            }
        }
        if ((productVirtualSettings = product.getProductVirtualSettings()) != null) {
            if ("virtual".equals(cpType.getName())) {
                ProductVirtualSettingsUtil.addOrUpdateProductVirtualSettings(cpDefinition, productVirtualSettings, this._cpDefinitionVirtualSettingService, this._cpdVirtualSettingFileEntryService, this._dlAppService, this._repositoryLocalService, this._uniqueFileNameProvider, serviceContext);
            } else {
                throw new CPDefinitionProductTypeNameException();
            }
        }
        return cpDefinition;
    }

    private CPDefinition _updateProduct(CPDefinition cpDefinition, Product product) throws Exception {
        Map expando;
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        int productStatus = GetterUtil.getInteger((Object)product.getProductStatus());
        if (productStatus == 2) {
            serviceContext.setWorkflowAction(2);
        }
        cpDefinition = this._getCPDefinition(cpDefinition, serviceContext);
        String[] assetTagNames = product.getTags();
        if (assetTagNames == null) {
            assetTagNames = this.transformToArray(this._assetTagService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()), AssetTagModel::getName, String.class);
        }
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(CPDefinition.class.getName(), product.getCustomFields()));
        Category[] categories = product.getCategories();
        if (categories == null) {
            serviceContext.setAssetCategoryIds(this._assetCategoryLocalService.getCategoryIds(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId()));
        } else {
            serviceContext.setAssetCategoryIds(this.transformToLongArray(Arrays.asList(categories), category -> {
                if (Validator.isNull((String)category.getExternalReferenceCode())) {
                    return category.getId();
                }
                AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(category.getExternalReferenceCode(), this.contextCompany.getGroupId());
                return assetCategory.getCategoryId();
            }));
        }
        Map nameMap = product.getName();
        if (cpDefinition != null && nameMap == null) {
            nameMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
        }
        Map shortDescriptionMap = product.getShortDescription();
        if (cpDefinition != null && shortDescriptionMap == null) {
            shortDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
        }
        Map descriptionMap = product.getDescription();
        if (cpDefinition != null && descriptionMap == null) {
            descriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
        }
        Map urlTitleMap = product.getUrls();
        if (cpDefinition != null && urlTitleMap == null) {
            urlTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getUrlTitleMap());
        }
        Map metaTitleMap = product.getMetaTitle();
        if (cpDefinition != null && metaTitleMap == null) {
            metaTitleMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
        }
        Map metaDescriptionMap = product.getMetaDescription();
        if (cpDefinition != null && metaDescriptionMap == null) {
            metaDescriptionMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
        }
        Map metaKeywordsMap = product.getMetaKeyword();
        if (cpDefinition != null && metaKeywordsMap == null) {
            metaKeywordsMap = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
        }
        DateConfig displayDateConfig = new DateConfig(DateConfigUtil.convertDateToCalendar(GetterUtil.getDate((Object)product.getDisplayDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpDefinition.getDisplayDate())));
        DateConfig expirationDateConfig = DateConfig.toExpirationDateConfig((Date)GetterUtil.getDate((Object)product.getExpirationDate(), (DateFormat)DateFormatFactoryUtil.getDate((Locale)this.contextAcceptLanguage.getPreferredLocale(), (TimeZone)this.contextUser.getTimeZone()), (Date)cpDefinition.getExpirationDate()), (TimeZone)this.contextUser.getTimeZone());
        cpDefinition = this._cpDefinitionService.updateCPDefinition(cpDefinition.getCPDefinitionId(), LanguageUtils.getLocalizedMap((Map)nameMap), LanguageUtils.getLocalizedMap((Map)shortDescriptionMap), LanguageUtils.getLocalizedMap((Map)descriptionMap), LanguageUtils.getLocalizedMap((Map)urlTitleMap), LanguageUtils.getLocalizedMap((Map)metaTitleMap), LanguageUtils.getLocalizedMap((Map)metaDescriptionMap), LanguageUtils.getLocalizedMap((Map)metaKeywordsMap), cpDefinition.isIgnoreSKUCombinations(), cpDefinition.getDDMStructureKey(), true, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)product.getNeverExpire(), (cpDefinition.getExpirationDate() == null ? 1 : 0) != 0), serviceContext);
        if (!Validator.isBlank((String)product.getExternalReferenceCode())) {
            this._cpDefinitionService.updateExternalReferenceCode(product.getExternalReferenceCode(), cpDefinition.getCPDefinitionId());
        }
        if (product.getActive() != null && !product.getActive().booleanValue()) {
            HashMap workflowContext = new HashMap();
            this._cpDefinitionService.updateStatus(cpDefinition.getCPDefinitionId(), 5, serviceContext, workflowContext);
        }
        if ((expando = product.getExpando()) != null && !expando.isEmpty()) {
            ExpandoUtil.updateExpando((long)serviceContext.getCompanyId(), CPDefinition.class, (long)cpDefinition.getPrimaryKey(), (Map)expando);
        }
        return this._updateNestedResources(product, cpDefinition, serviceContext);
    }
}

