/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPOptionException;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionValue;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.OptionEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionValueResource;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/option.properties"}, scope=ServiceScope.PROTOTYPE, service={OptionResource.class})
public class OptionResourceImpl
extends BaseOptionResourceImpl {
    private static final EntityModel _entityModel = new OptionEntityModel();
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPOption)")
    private ModelResourcePermission<CPOption> _cpOptionModelResourcePermission;
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.OptionDTOConverter)")
    private DTOConverter<CPOption, Option> _optionDTOConverter;
    @Reference
    private OptionValueResource _optionValueResource;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOption(Long id) throws Exception {
        CPOption cpOption = this._cpOptionService.getCPOption(id.longValue());
        this._cpOptionService.deleteCPOption(cpOption.getCPOptionId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteOptionByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchCPOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find option with external reference code " + externalReferenceCode);
        }
        this._cpOptionService.deleteCPOption(cpOption.getCPOptionId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Option getOption(Long id) throws Exception {
        return this._toOption(GetterUtil.getLong((Object)id));
    }

    @Override
    public Option getOptionByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchCPOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this._toOption(cpOption.getCPOptionId());
    }

    @Override
    public Page<Option> getOptionsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPOption.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toOption(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    @Override
    public Response patchOption(Long id, Option option) throws Exception {
        this._updateOption(this._cpOptionService.getCPOption(id.longValue()), option);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchOptionByExternalReferenceCode(String externalReferenceCode, Option option) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchCPOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find option with external reference code " + externalReferenceCode);
        }
        this._updateOption(cpOption, option);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Option postOption(Option option) throws Exception {
        return this._addOrUpdateOption(option.getExternalReferenceCode(), option);
    }

    @Override
    public Option putOptionByExternalReferenceCode(String externalReferenceCode, Option option) throws Exception {
        return this._addOrUpdateOption(externalReferenceCode, option);
    }

    private Option _addOrUpdateOption(String externalReferenceCode, Option option) throws Exception {
        Option.FieldType fieldType = option.getFieldType();
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(option));
        CPOption cpOption = this._cpOptionService.addOrUpdateCPOption(externalReferenceCode, LanguageUtils.getLocalizedMap((Map)option.getName()), LanguageUtils.getLocalizedMap((Map)option.getDescription()), fieldType.getValue(), GetterUtil.get((Object)option.getFacetable(), (boolean)false), GetterUtil.get((Object)option.getRequired(), (boolean)false), GetterUtil.get((Object)option.getSkuContributor(), (boolean)false), option.getKey(), serviceContext);
        this._addOrUpdateOptionValues(cpOption, option.getOptionValues());
        return this._toOption(cpOption.getCPOptionId());
    }

    private void _addOrUpdateOptionValues(CPOption cpOption, OptionValue[] optionValues) throws Exception {
        if (ArrayUtil.isEmpty((Object[])optionValues)) {
            return;
        }
        this._optionValueResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this._optionValueResource.setContextCompany(this.contextCompany);
        this._optionValueResource.setContextUriInfo(this.contextUriInfo);
        for (OptionValue optionValue : optionValues) {
            this._optionValueResource.postOptionIdOptionValue(Long.valueOf(cpOption.getCPOptionId()), optionValue);
        }
    }

    private Map<String, Map<String, String>> _getActions(long cpOptionId) {
        return HashMapBuilder.put((Object)"delete", this.addAction("DELETE", cpOptionId, "deleteOption", this._cpOptionModelResourcePermission)).put((Object)"get", this.addAction("VIEW", cpOptionId, "getOption", this._cpOptionModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", cpOptionId, "patchOption", this._cpOptionModelResourcePermission)).build();
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(Option option) {
        HashMap expandoBridgeAttributes = CustomFieldsUtil.toMap((String)CPOption.class.getName(), (long)this.contextCompany.getCompanyId(), (CustomField[])option.getCustomFields(), (Locale)this.contextAcceptLanguage.getPreferredLocale());
        if (expandoBridgeAttributes == null) {
            expandoBridgeAttributes = new HashMap();
        }
        return expandoBridgeAttributes;
    }

    private Option _toOption(Long cpOptionId) throws Exception {
        return (Option)this._optionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpOptionId), this._dtoConverterRegistry, (Object)cpOptionId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private Option _updateOption(CPOption cpOption, Option option) throws Exception {
        Option.FieldType fieldType = option.getFieldType();
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(option));
        cpOption = this._cpOptionService.updateCPOption(cpOption.getCPOptionId(), LanguageUtils.getLocalizedMap((Map)option.getName()), LanguageUtils.getLocalizedMap((Map)option.getDescription()), fieldType.getValue(), GetterUtil.get((Object)option.getFacetable(), (boolean)cpOption.isFacetable()), GetterUtil.get((Object)option.getRequired(), (boolean)cpOption.isRequired()), GetterUtil.get((Object)option.getSkuContributor(), (boolean)cpOption.isSkuContributor()), option.getKey(), serviceContext);
        return this._toOption(cpOption.getCPOptionId());
    }
}

