/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListRel;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListChannel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.inventory.model.CommerceChannelRel"}, service={DTOConverter.class})
public class ProductConfigurationListChannelDTOConverter
implements DTOConverter<CPConfigurationListRel, ProductConfigurationListChannel> {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;

    public String getContentType() {
        return ProductConfigurationListChannel.class.getSimpleName();
    }

    public ProductConfigurationListChannel toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CommerceChannelRel commerceChannelRel = this._commerceChannelRelService.getCommerceChannelRel(((Long)dtoConverterContext.getId()).longValue());
        final CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelRel.getCommerceChannelId());
        final CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationList(commerceChannelRel.getClassPK());
        return new ProductConfigurationListChannel(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setChannel(() -> new Channel(){
                    {
                        this.setCurrencyCode(() -> ((CommerceChannel)commerceChannel).getCommerceCurrencyCode());
                        this.setExternalReferenceCode(() -> ((CommerceChannel)commerceChannel).getExternalReferenceCode());
                        this.setId(() -> ((CommerceChannel)commerceChannel).getCommerceChannelId());
                        this.setName(() -> ((CommerceChannel)commerceChannel).getName());
                        this.setSiteGroupId(() -> ((CommerceChannel)commerceChannel).getSiteGroupId());
                        this.setType(() -> ((CommerceChannel)commerceChannel).getType());
                    }
                });
                this.setChannelExternalReferenceCode(() -> ((CommerceChannel)commerceChannel).getExternalReferenceCode());
                this.setChannelId(() -> ((CommerceChannel)commerceChannel).getCommerceChannelId());
                this.setProductConfigurationListChannelId(() -> ((CommerceChannelRel)commerceChannelRel).getCommerceChannelRelId());
                this.setProductConfigurationListExternalReferenceCode(() -> ((CPConfigurationList)cpConfigurationList).getExternalReferenceCode());
                this.setProductConfigurationListId(() -> ((CPConfigurationList)cpConfigurationList).getCPConfigurationListId());
            }
        };
    }
}

