/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.crud.VulcanCRUDItemDelegate;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseCatalogResourceImpl
implements CatalogResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<Catalog>,
VulcanCRUDItemDelegate<Catalog> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<Catalog>, UnsafeFunction<Catalog, Catalog, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<Catalog>, UnsafeConsumer<Catalog, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseCatalogResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Tags(value={@Tag(name="Catalog")})
    @DELETE
    @Path(value="/catalog/{id}")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteCatalog(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/catalog/batch")
    @Produces(value={"application/json"})
    public Response deleteCatalogBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Catalog.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Catalog")})
    @DELETE
    @Path(value="/catalog/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteCatalogByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Tags(value={@Tag(name="Catalog")})
    @GET
    @Path(value="/catalog/{id}")
    @Produces(value={"application/json", "application/xml"})
    public Catalog getCatalog(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id) throws Exception {
        return new Catalog();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Catalog")})
    @GET
    @Path(value="/catalog/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Catalog getCatalogByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Catalog();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="Catalog")})
    @GET
    @Path(value="/catalogs")
    @Produces(value={"application/json", "application/xml"})
    public Page<Catalog> getCatalogsPage(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="Catalog")})
    @GET
    @Path(value="/products/by-externalReferenceCode/{externalReferenceCode}/catalog")
    @Produces(value={"application/json", "application/xml"})
    public Catalog getProductByExternalReferenceCodeCatalog(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, @Context Pagination pagination) throws Exception {
        return new Catalog();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="Catalog")})
    @GET
    @Path(value="/products/{id}/catalog")
    @Produces(value={"application/json", "application/xml"})
    public Catalog getProductIdCatalog(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id, @Context Pagination pagination) throws Exception {
        return new Catalog();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="id")})
    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/catalog/{id}")
    @Produces(value={"application/json", "application/xml"})
    public Response patchCatalog(@Parameter(hidden=true) @NotNull @PathParam(value="id") Long id, Catalog catalog) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/catalog/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public Response patchCatalogByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Catalog catalog) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/catalogs")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public Catalog postCatalog(Catalog catalog) throws Exception {
        return new Catalog();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json"})
    @Path(value="/catalogs/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postCatalogBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Catalog.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort"), @Parameter(in=ParameterIn.QUERY, name="callbackURL"), @Parameter(in=ParameterIn.QUERY, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="fieldNames")})
    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json"})
    @Path(value="/catalogs/export-batch")
    @POST
    @Produces(value={"application/json"})
    public Response postCatalogsPageExportBatch(@Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Sort[] sorts, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, @Parameter(hidden=true) @DefaultValue(value="JSON") @QueryParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="fieldNames") String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineExportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineExportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineExportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineExportTaskResource.setContextUser(this.contextUser);
        this.vulcanBatchEngineExportTaskResource.setGroupLocalService(this.groupLocalService);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineExportTaskResource.postExportTask(Catalog.class.getName(), callbackURL, contentType, fieldNames)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="Catalog")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/catalog/by-externalReferenceCode/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Catalog putCatalogByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, Catalog catalog) throws Exception {
        return new Catalog();
    }

    public void create(Collection<Catalog> catalogs, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction catalogUnsafeFunction = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
            catalogUnsafeFunction = catalog -> this.postCatalog((Catalog)catalog);
        }
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
            String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
                catalogUnsafeFunction = catalog -> {
                    Catalog persistedCatalog = null;
                    try {
                        Catalog getCatalog = this.getCatalogByExternalReferenceCode(catalog.getExternalReferenceCode());
                        this.patchCatalog(getCatalog.getId() != null ? getCatalog.getId() : this._parseLong((String)parameters.get("catalogId")), (Catalog)catalog);
                    }
                    catch (NoSuchModelException noSuchModelException) {
                        persistedCatalog = this.postCatalog((Catalog)catalog);
                    }
                    return persistedCatalog;
                };
            }
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
                catalogUnsafeFunction = catalog -> this.putCatalogByExternalReferenceCode(catalog.getExternalReferenceCode(), (Catalog)catalog);
            }
        }
        if (catalogUnsafeFunction == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for Catalog");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(catalogs, (Object)catalogUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(catalogs, arg_0 -> ((UnsafeFunction)catalogUnsafeFunction).apply(arg_0));
        } else {
            for (Catalog catalog2 : catalogs) {
                catalogUnsafeFunction.apply((Object)catalog2);
            }
        }
    }

    public void delete(Collection<Catalog> catalogs, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction catalogUnsafeFunction = catalog -> {
            if (catalog.getId() != null) {
                try {
                    this.deleteCatalog(catalog.getId());
                    return catalog;
                }
                catch (Exception exception) {
                    if (catalog.getExternalReferenceCode() != null) {
                        this.deleteCatalogByExternalReferenceCode(catalog.getExternalReferenceCode());
                        return catalog;
                    }
                }
            } else if (catalog.getExternalReferenceCode() != null) {
                this.deleteCatalogByExternalReferenceCode(catalog.getExternalReferenceCode());
                return catalog;
            }
            throw new UnsupportedOperationException("Unable to delete by external reference code or ID");
        };
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(catalogs, (Object)catalogUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(catalogs, arg_0 -> ((UnsafeFunction)catalogUnsafeFunction).apply(arg_0));
        } else {
            for (Catalog catalog2 : catalogs) {
                catalogUnsafeFunction.apply((Object)catalog2);
            }
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT", "UPSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "Catalog";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<Catalog> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getCatalogsPage(search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Catalog> catalogs, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction catalogUnsafeFunction = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
            catalogUnsafeFunction = catalog -> {
                this.patchCatalog(catalog.getId() != null ? catalog.getId() : this._parseLong((String)parameters.get("catalogId")), (Catalog)catalog);
                return null;
            };
        }
        if (catalogUnsafeFunction == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for Catalog");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(catalogs, (Object)catalogUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(catalogs, arg_0 -> ((UnsafeFunction)catalogUnsafeFunction).apply(arg_0));
        } else {
            for (Catalog catalog2 : catalogs) {
                catalogUnsafeFunction.apply((Object)catalog2);
            }
        }
    }

    private Long _parseLong(String value) {
        if (value != null) {
            return Long.parseLong(value);
        }
        return null;
    }

    public Catalog getItem(Long id) throws Exception {
        return this.getCatalog(id);
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<Catalog>, UnsafeFunction<Catalog, Catalog, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<Catalog>, UnsafeConsumer<Catalog, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-commerce-admin-catalog";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

