/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.commerce.admin.catalog.internal.jaxrs.exception.mapper;

import com.liferay.commerce.product.exception.CPDefinitionOptionValueRelCPInstanceException;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.BaseExceptionMapper;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.Problem;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.osgi.service.component.annotations.Component;

/**
 * @author João Cordeiro
 */
@Component(
	property = {
		"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.Headless.Commerce.Admin.Catalog)",
		"osgi.jaxrs.extension=true",
		"osgi.jaxrs.name=Liferay.Headless.Commerce.Admin.Catalog.OptionValueSkuIdExceptionMapper"
	},
	service = ExceptionMapper.class
)
public class OptionValueSkuIdExceptionMapper
	extends BaseExceptionMapper<CPDefinitionOptionValueRelCPInstanceException> {

	@Override
	protected Problem getProblem(
		CPDefinitionOptionValueRelCPInstanceException
			cpDefinitionOptionValueRelCPInstanceException) {

		return new Problem(
			Response.Status.BAD_REQUEST, "Option value sku ID is invalid");
	}

}