/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util;

import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class FileEntryUtil {
    private static final Log _log = LogFactoryUtil.getLog(FileEntryUtil.class);

    public static long getFileEntryId(BinaryFile binaryFile, long commerceCatalogGroupId, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider) throws PortalException {
        FileEntry fileEntry = FileEntryUtil._addFileEntry(commerceCatalogGroupId, cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, binaryFile);
        return fileEntry.getFileEntryId();
    }

    public static long getFileEntryId(String attachment, String url, long commerceCatalogGroupId, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((String)attachment) && Validator.isNull((String)url)) {
            serviceContext.setExpandoBridgeAttributes(new HashMap());
            File tempFile = FileUtil.createTempFile((byte[])Base64.decode((String)attachment));
            FileEntry fileEntry = FileEntryUtil._addFileEntry(commerceCatalogGroupId, cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, new BinaryFile(MimeTypesUtil.getContentType((File)tempFile), tempFile.getName(), (InputStream)new FileInputStream(tempFile), tempFile.length()));
            FileUtil.delete((File)tempFile);
            return fileEntry.getFileEntryId();
        }
        return 0L;
    }

    private static FileEntry _addFileEntry(long commerceCatalogGroupId, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, BinaryFile binaryFile) throws PortalException {
        DLValidatorUtil.validateFileSize((long)commerceCatalogGroupId, (String)binaryFile.getFileName(), (String)binaryFile.getContentType(), (long)binaryFile.getSize());
        Repository repository = repositoryLocalService.fetchRepository(commerceCatalogGroupId, "com.liferay.commerce.product");
        String uniqueFileName = uniqueFileNameProvider.provide(binaryFile.getFileName(), curFileName -> FileEntryUtil._exists(commerceCatalogGroupId, dlAppService, repository, curFileName));
        return cpdVirtualSettingFileEntryService.addFileEntry(commerceCatalogGroupId, repository != null ? repository.getDlFolderId() : 0L, binaryFile.getInputStream(), uniqueFileName, binaryFile.getContentType(), "com.liferay.commerce.product");
    }

    private static boolean _exists(long groupId, DLAppService dlAppService, Repository repository, String fileName) {
        try {
            if (repository == null) {
                return false;
            }
            FileEntry fileEntry = dlAppService.getFileEntryByFileName(groupId, repository.getDlFolderId(), fileName);
            return fileEntry != null;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return false;
        }
    }
}

