/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.product.exception.NoSuchCPConfigurationListException;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListRel;
import com.liferay.commerce.product.service.CPConfigurationListRelService;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.commerce.service.CommerceOrderTypeService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationList;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListOrderType;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductConfigurationListOrderTypeResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationListOrderTypeResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-configuration-list-order-type.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductConfigurationListOrderTypeResource.class})
public class ProductConfigurationListOrderTypeResourceImpl
extends BaseProductConfigurationListOrderTypeResourceImpl {
    @Reference
    private CommerceOrderTypeService _commerceOrderTypeService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPConfigurationListRel)")
    private ModelResourcePermission<CPConfigurationListRel> _cpConfigurationListRelModelResourcePermission;
    @Reference
    private CPConfigurationListRelService _cpConfigurationListRelService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationListOrderTypeDTOConverter)")
    private DTOConverter<CPConfigurationListRel, ProductConfigurationListOrderType> _productConfigurationListOrderTypeDTOConverter;

    @Override
    public void deleteProductConfigurationListOrderType(Long id) throws Exception {
        this._cpConfigurationListRelService.deleteCPConfigurationListRel(id.longValue());
    }

    @Override
    public Page<ProductConfigurationListOrderType> getProductConfigurationListByExternalReferenceCodeProductConfigurationListOrderTypesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.fetchCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpConfigurationList == null) {
            throw new NoSuchCPConfigurationListException("Unable to find product configuration list order type with external reference code " + externalReferenceCode);
        }
        return this.getProductConfigurationListIdProductConfigurationListOrderTypesPage(cpConfigurationList.getCPConfigurationListId(), null, null, pagination, null);
    }

    @Override
    @NestedField(parentClass=ProductConfigurationList.class, value="productConfigurationListOrderTypes")
    public Page<ProductConfigurationListOrderType> getProductConfigurationListIdProductConfigurationListOrderTypesPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of(this._toProductConfigurationListOrderTypes(this._cpConfigurationListRelService.getCommerceOrderTypeCPConfigurationListRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._cpConfigurationListRelService.getCommerceOrderTypeCPConfigurationListRelsCount(id.longValue(), search));
    }

    @Override
    public ProductConfigurationListOrderType postProductConfigurationListByExternalReferenceCodeProductConfigurationListOrderType(String externalReferenceCode, ProductConfigurationListOrderType productConfigurationListOrderType) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.fetchCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpConfigurationList == null) {
            throw new NoSuchCPConfigurationListException("Unable to find product configuration list order type with external reference code " + externalReferenceCode);
        }
        return this.postProductConfigurationListIdProductConfigurationListOrderType(cpConfigurationList.getCPConfigurationListId(), productConfigurationListOrderType);
    }

    @Override
    public ProductConfigurationListOrderType postProductConfigurationListIdProductConfigurationListOrderType(Long id, ProductConfigurationListOrderType productConfigurationListOrderType) throws Exception {
        CPConfigurationListRel cpConfigurationListRel = this._addCPConfigurationListRel(this._cpConfigurationListService.getCPConfigurationList(id.longValue()), productConfigurationListOrderType);
        return this._toProductConfigurationListOrderType(cpConfigurationListRel.getCPConfigurationListRelId());
    }

    private CPConfigurationListRel _addCPConfigurationListRel(CPConfigurationList cpConfigurationList, ProductConfigurationListOrderType productConfigurationListOrderType) throws Exception {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeService.fetchCommerceOrderTypeByExternalReferenceCode(GetterUtil.getString((String)productConfigurationListOrderType.getOrderTypeExternalReferenceCode()), cpConfigurationList.getCompanyId());
        if (commerceOrderType == null) {
            commerceOrderType = this._commerceOrderTypeService.getCommerceOrderType(productConfigurationListOrderType.getOrderTypeId().longValue());
        }
        return this._cpConfigurationListRelService.addCPConfigurationListRel(CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), cpConfigurationList.getCPConfigurationListId());
    }

    private Map<String, Map<String, String>> _getActions(long cpConfigurationListRelId) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", cpConfigurationListRelId, "deleteProductConfigurationListOrderType", this._cpConfigurationListRelModelResourcePermission)).build();
    }

    private ProductConfigurationListOrderType _toProductConfigurationListOrderType(Long cpConfigurationListRelId) throws Exception {
        return (ProductConfigurationListOrderType)this._productConfigurationListOrderTypeDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpConfigurationListRelId), this._dtoConverterRegistry, (Object)cpConfigurationListRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<ProductConfigurationListOrderType> _toProductConfigurationListOrderTypes(List<CPConfigurationListRel> cpConfigurationListRels) {
        return this.transform(cpConfigurationListRels, cpConfigurationListRel -> this._toProductConfigurationListOrderType(cpConfigurationListRel.getCPConfigurationListRelId()));
    }
}

