/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountGroupService;
import com.liferay.commerce.product.exception.NoSuchCPConfigurationListException;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListRel;
import com.liferay.commerce.product.service.CPConfigurationListRelService;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationList;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListAccountGroup;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductConfigurationListAccountGroupResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationListAccountGroupResource;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-configuration-list-account-group.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductConfigurationListAccountGroupResource.class})
public class ProductConfigurationListAccountGroupResourceImpl
extends BaseProductConfigurationListAccountGroupResourceImpl {
    @Reference
    private AccountGroupService _accountGroupService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPConfigurationListRel)")
    private ModelResourcePermission<CPConfigurationListRel> _cpConfigurationListRelModelResourcePermission;
    @Reference
    private CPConfigurationListRelService _cpConfigurationListRelService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationListAccountGroupDTOConverter)")
    private DTOConverter<CPConfigurationListRel, ProductConfigurationListAccountGroup> _productConfigurationListAccountGroupDTOConverter;

    @Override
    public void deleteProductConfigurationListAccountGroup(Long id) throws Exception {
        this._cpConfigurationListRelService.deleteCPConfigurationListRel(id.longValue());
    }

    @Override
    public Page<ProductConfigurationListAccountGroup> getProductConfigurationListByExternalReferenceCodeProductConfigurationListAccountGroupsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.fetchCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpConfigurationList == null) {
            throw new NoSuchCPConfigurationListException("Unable to find product configuration list account group with external reference code " + externalReferenceCode);
        }
        return this.getProductConfigurationListIdProductConfigurationListAccountGroupsPage(cpConfigurationList.getCPConfigurationListId(), null, null, pagination, null);
    }

    @Override
    @NestedField(parentClass=ProductConfigurationList.class, value="productConfigurationListAccountGroups")
    public Page<ProductConfigurationListAccountGroup> getProductConfigurationListIdProductConfigurationListAccountGroupsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of(this._toProductConfigurationListAccountGroups(this._cpConfigurationListRelService.getAccountGroupCPConfigurationListRels(id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._cpConfigurationListRelService.getAccountGroupCPConfigurationListRelsCount(id.longValue(), search));
    }

    @Override
    public ProductConfigurationListAccountGroup postProductConfigurationListByExternalReferenceCodeProductConfigurationListAccountGroup(String externalReferenceCode, ProductConfigurationListAccountGroup productConfigurationListAccountGroup) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.fetchCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpConfigurationList == null) {
            throw new NoSuchCPConfigurationListException("Unable to find product configuration list account group with external reference code " + externalReferenceCode);
        }
        return this.postProductConfigurationListIdProductConfigurationListAccountGroup(cpConfigurationList.getCPConfigurationListId(), productConfigurationListAccountGroup);
    }

    @Override
    public ProductConfigurationListAccountGroup postProductConfigurationListIdProductConfigurationListAccountGroup(Long id, ProductConfigurationListAccountGroup productConfigurationListAccountGroup) throws Exception {
        CPConfigurationListRel cpConfigurationListRel = this._addCPConfigurationListRel(this._cpConfigurationListService.getCPConfigurationList(id.longValue()), productConfigurationListAccountGroup);
        return this._toProductConfigurationListAccountGroup(cpConfigurationListRel.getCPConfigurationListRelId());
    }

    private CPConfigurationListRel _addCPConfigurationListRel(CPConfigurationList cpConfigurationList, ProductConfigurationListAccountGroup productConfigurationListAccountGroup) throws Exception {
        AccountGroup accountGroup = this._accountGroupService.fetchAccountGroupByExternalReferenceCode(GetterUtil.getString((String)productConfigurationListAccountGroup.getAccountGroupExternalReferenceCode()), cpConfigurationList.getCompanyId());
        if (accountGroup == null) {
            accountGroup = this._accountGroupService.getAccountGroup(productConfigurationListAccountGroup.getAccountGroupId().longValue());
        }
        return this._cpConfigurationListRelService.addCPConfigurationListRel(AccountGroup.class.getName(), accountGroup.getAccountGroupId(), cpConfigurationList.getCPConfigurationListId());
    }

    private Map<String, Map<String, String>> _getActions(long cpConfigurationListRelId) throws Exception {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", cpConfigurationListRelId, "deleteProductConfigurationListAccountGroup", this._cpConfigurationListRelModelResourcePermission)).build();
    }

    private ProductConfigurationListAccountGroup _toProductConfigurationListAccountGroup(Long cpConfigurationListRelId) throws Exception {
        return (ProductConfigurationListAccountGroup)this._productConfigurationListAccountGroupDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpConfigurationListRelId), this._dtoConverterRegistry, (Object)cpConfigurationListRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<ProductConfigurationListAccountGroup> _toProductConfigurationListAccountGroups(List<CPConfigurationListRel> cpConfigurationListRels) {
        return this.transform(cpConfigurationListRels, cpConfigurationListRel -> this._toProductConfigurationListAccountGroup(cpConfigurationListRel.getCPConfigurationListRelId()));
    }
}

