/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPOptionException;
import com.liferay.commerce.product.exception.NoSuchCPOptionValueException;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.commerce.product.service.CPOptionValueService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionValue;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.util.CustomFieldsUtil;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionValueResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionValueResource;
import com.liferay.headless.commerce.core.util.ActionUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/option-value.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={OptionValueResource.class})
public class OptionValueResourceImpl
extends BaseOptionValueResourceImpl {
    @Reference
    private CPOptionService _cpOptionService;
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPOption)")
    private ModelResourcePermission<CPOption> _cpOptionValueModelResourcePermission;
    @Reference
    private CPOptionValueService _cpOptionValueService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.OptionValueDTOConverter)")
    private DTOConverter<CPOptionValue, OptionValue> _optionValueDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOptionValue(Long id) throws Exception {
        this._cpOptionValueService.deleteCPOptionValue(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteOptionValueByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOptionValue cpOptionValue = this._cpOptionValueService.fetchCPOptionValueByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOptionValue == null) {
            throw new NoSuchCPOptionValueException("Unable to find option value with external reference code " + externalReferenceCode);
        }
        this._cpOptionValueService.deleteCPOptionValue(cpOptionValue.getCPOptionValueId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Page<OptionValue> getOptionByExternalReferenceCodeOptionValuesPage(String externalReferenceCode, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchCPOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find option with external reference code " + externalReferenceCode);
        }
        BaseModelSearchResult cpOptionValueBaseModelSearchResult = this._cpOptionValueService.searchCPOptionValues(cpOption.getCompanyId(), cpOption.getCPOptionId(), search, pagination.getStartPosition(), pagination.getEndPosition(), sorts);
        int totalCount = this._cpOptionValueService.searchCPOptionValuesCount(cpOption.getCompanyId(), cpOption.getCPOptionId(), search);
        return Page.of(this._toOptionValues(cpOptionValueBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)totalCount);
    }

    @Override
    @NestedField(parentClass=Option.class, value="optionValues")
    public Page<OptionValue> getOptionIdOptionValuesPage(Long id, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPOption cpOption = this._cpOptionService.getCPOption(id.longValue());
        BaseModelSearchResult cpOptionValueBaseModelSearchResult = this._cpOptionValueService.searchCPOptionValues(cpOption.getCompanyId(), cpOption.getCPOptionId(), search, pagination.getStartPosition(), pagination.getEndPosition(), sorts);
        int totalCount = this._cpOptionValueService.searchCPOptionValuesCount(cpOption.getCompanyId(), cpOption.getCPOptionId(), search);
        return Page.of(this._toOptionValues(cpOptionValueBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)totalCount);
    }

    @Override
    public OptionValue getOptionValue(Long id) throws Exception {
        return this._toOptionValue(id);
    }

    @Override
    public OptionValue getOptionValueByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOptionValue cpOptionValue = this._cpOptionValueService.fetchCPOptionValueByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOptionValue == null) {
            throw new NoSuchCPOptionValueException("Unable to find option value with external reference code " + externalReferenceCode);
        }
        return this._toOptionValue(cpOptionValue.getCPOptionValueId());
    }

    @Override
    public Response patchOptionValue(Long id, OptionValue optionValue) throws Exception {
        this._updateOptionValue(this._cpOptionValueService.getCPOptionValue(id.longValue()), optionValue);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchOptionValueByExternalReferenceCode(String externalReferenceCode, OptionValue optionValue) throws Exception {
        CPOptionValue cpOptionValue = this._cpOptionValueService.fetchCPOptionValueByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOptionValue == null) {
            throw new NoSuchCPOptionValueException("Unable to find option value with external reference code " + externalReferenceCode);
        }
        this._updateOptionValue(cpOptionValue, optionValue);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OptionValue postOptionByExternalReferenceCodeOptionValue(String externalReferenceCode, OptionValue optionValue) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchCPOptionByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find option with external reference code " + externalReferenceCode);
        }
        return this._addOrUpdateOptionValue(cpOption, optionValue);
    }

    @Override
    public OptionValue postOptionIdOptionValue(Long id, OptionValue optionValue) throws Exception {
        return this._addOrUpdateOptionValue(this._cpOptionService.getCPOption(id.longValue()), optionValue);
    }

    private Map<String, String> _addAction(String actionId, long cpOptionValueId, UriInfo uriInfo, String methodName, Class<?> clazz) throws Exception {
        CPOptionValue cpOptionValue = this._cpOptionValueService.getCPOptionValue(cpOptionValueId);
        if (!this._cpOptionValueModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), cpOptionValue.getCPOptionId(), actionId)) {
            return null;
        }
        return HashMapBuilder.put((Object)"href", () -> {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            return uriBuilder.path(ActionUtil.getVersion((UriInfo)uriInfo)).path(clazz.getSuperclass(), methodName).toTemplate();
        }).put((Object)"method", (Object)ActionUtil.getHttpMethodName(clazz, (Method)ActionUtil.getMethod(clazz, (String)methodName))).build();
    }

    private OptionValue _addOrUpdateOptionValue(CPOption cpOption, OptionValue optionValue) throws Exception {
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(optionValue));
        CPOptionValue cpOptionValue = this._cpOptionValueService.addOrUpdateCPOptionValue(optionValue.getExternalReferenceCode(), cpOption.getCPOptionId(), LanguageUtils.getLocalizedMap((Map)optionValue.getName()), GetterUtil.get((Object)optionValue.getPriority(), (double)0.0), optionValue.getKey(), serviceContext);
        return this._toOptionValue(cpOptionValue.getCPOptionValueId());
    }

    private Map<String, Map<String, String>> _getActions(long cpOptionValueId) throws Exception {
        return HashMapBuilder.put((Object)"delete", this._addAction("DELETE", cpOptionValueId, this.contextUriInfo, "deleteOptionValue", this.getClass())).put((Object)"get", this._addAction("VIEW", cpOptionValueId, this.contextUriInfo, "getOptionValue", this.getClass())).put((Object)"update", this._addAction("UPDATE", cpOptionValueId, this.contextUriInfo, "patchOptionValue", this.getClass())).build();
    }

    private Map<String, Serializable> _getExpandoBridgeAttributes(OptionValue optionValue) {
        Map<String, Serializable> expandoBridgeAttributes = CustomFieldsUtil.toMap(CPOptionValue.class.getName(), this.contextCompany.getCompanyId(), optionValue.getCustomFields(), this.contextAcceptLanguage.getPreferredLocale());
        if (expandoBridgeAttributes == null) {
            expandoBridgeAttributes = new HashMap<String, Serializable>();
        }
        return expandoBridgeAttributes;
    }

    private OptionValue _toOptionValue(Long cpOptionValueId) throws Exception {
        return (OptionValue)this._optionValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpOptionValueId), this._dtoConverterRegistry, (Object)cpOptionValueId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<OptionValue> _toOptionValues(List<CPOptionValue> cpOptionValues) throws Exception {
        return this.transform(cpOptionValues, cpOptionValue -> this._toOptionValue(cpOptionValue.getCPOptionValueId()));
    }

    private OptionValue _updateOptionValue(CPOptionValue cpOptionValue, OptionValue optionValue) throws Exception {
        Map name = optionValue.getName();
        Map nameMap = null;
        nameMap = MapUtil.isEmpty((Map)name) ? cpOptionValue.getNameMap() : LanguageUtils.getLocalizedMap((Map)name);
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext();
        serviceContext.setExpandoBridgeAttributes(this._getExpandoBridgeAttributes(optionValue));
        cpOptionValue = this._cpOptionValueService.updateCPOptionValue(cpOptionValue.getCPOptionValueId(), nameMap, GetterUtil.get((Object)optionValue.getPriority(), (double)cpOptionValue.getPriority()), GetterUtil.get((String)optionValue.getKey(), (String)cpOptionValue.getKey()), serviceContext);
        return this._toOptionValue(cpOptionValue.getCPOptionValueId());
    }
}

