/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.asset.kernel.exception.NoSuchCategoryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseCategoryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CategoryResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/category.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={CategoryResource.class})
public class CategoryResourceImpl
extends BaseCategoryResourceImpl {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.CategoryDTOConverter)")
    private DTOConverter<AssetCategory, Category> _categoryDTOConverter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Page<Category> getProductByExternalReferenceCodeCategoriesPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        List assetCategories = this._assetCategoryService.getCategories(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalCount = this._assetCategoryService.getCategoriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductCategories(assetCategories, this.contextAcceptLanguage.getPreferredLocale()), (Pagination)pagination, (long)totalCount);
    }

    @Override
    @NestedField(parentClass=Product.class, value="categories")
    public Page<Category> getProductIdCategoriesPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        List assetCategories = this._assetCategoryService.getCategories(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalCount = this._assetCategoryService.getCategoriesCount(this._classNameLocalService.getClassNameId(cpDefinition.getModelClass()), cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductCategories(assetCategories, this.contextAcceptLanguage.getPreferredLocale()), (Pagination)pagination, (long)totalCount);
    }

    @Override
    public Response patchProductByExternalReferenceCodeCategory(String externalReferenceCode, Category[] categories) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        this._updateProductCategories(cpDefinition, categories);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdCategory(Long id, Category[] categories) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        this._updateProductCategories(cpDefinition, categories);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    private List<Category> _toProductCategories(List<AssetCategory> assetCategories, Locale locale) throws Exception {
        return this.transform(assetCategories, category -> (Category)this._categoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)category.getCategoryId(), locale)));
    }

    private void _updateProductCategories(CPDefinition cpDefinition, Category[] categories) throws Exception {
        long[] assetCategoryIds = new long[]{};
        for (Category category : categories) {
            AssetCategory assetCategory = this._assetCategoryService.fetchCategory(category.getId().longValue());
            if (assetCategory == null) {
                throw new NoSuchCategoryException("Unable to find Category with ID: " + category.getId());
            }
            assetCategoryIds = ArrayUtil.append((long[])assetCategoryIds, (long)assetCategory.getCategoryId());
        }
        ServiceContext serviceContext = this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        this._cpDefinitionService.updateCPDefinitionCategorization(cpDefinition.getCPDefinitionId(), serviceContext);
    }
}

