/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListRel;
import com.liferay.commerce.product.service.CPConfigurationListRelService;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Account;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListAccount;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPConfigurationListRel"}, service={DTOConverter.class})
public class ProductConfigurationListAccountDTOConverter
implements DTOConverter<CPConfigurationListRel, ProductConfigurationListAccount> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CPConfigurationListRelService _cpConfigurationListRelService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;

    public String getContentType() {
        return ProductConfigurationListAccount.class.getSimpleName();
    }

    public ProductConfigurationListAccount toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPConfigurationListRel cpConfigurationListRel = this._cpConfigurationListRelService.getCPConfigurationListRel(((Long)dtoConverterContext.getId()).longValue());
        final AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(cpConfigurationListRel.getClassPK());
        final CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationList(cpConfigurationListRel.getCPConfigurationListId());
        return new ProductConfigurationListAccount(){
            {
                this.setAccount(() -> new Account(){
                    {
                        this.setId(() -> ((AccountEntry)accountEntry).getAccountEntryId());
                        this.setLogoId(() -> ((AccountEntry)accountEntry).getLogoId());
                        this.setName(() -> ((AccountEntry)accountEntry).getName());
                    }
                });
                this.setAccountExternalReferenceCode(() -> ((AccountEntry)accountEntry).getExternalReferenceCode());
                this.setAccountId(() -> ((AccountEntry)accountEntry).getAccountEntryId());
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setProductConfigurationListAccountId(() -> ((CPConfigurationListRel)cpConfigurationListRel).getCPConfigurationListRelId());
                this.setProductConfigurationListExternalReferenceCode(() -> ((CPConfigurationList)cpConfigurationList).getExternalReferenceCode());
                this.setProductConfigurationListId(() -> ((CPConfigurationList)cpConfigurationList).getCPConfigurationListId());
            }
        };
    }
}

