/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductSubscriptionConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSubscriptionConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSubscriptionConfigurationResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-subscription-configuration.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductSubscriptionConfigurationResource.class})
public class ProductSubscriptionConfigurationResourceImpl
extends BaseProductSubscriptionConfigurationResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductSubscriptionConfigurationDTOConverter)")
    private DTOConverter<CPDefinition, ProductSubscriptionConfiguration> _productSubscriptionConfigurationDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public ProductSubscriptionConfiguration getProductByExternalReferenceCodeSubscriptionConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this._toProductSubscriptionConfiguration(cpDefinition.getCPDefinitionId());
    }

    @Override
    @NestedField(parentClass=Product.class, value="subscriptionConfiguration")
    public ProductSubscriptionConfiguration getProductIdSubscriptionConfiguration(@NestedFieldId(value="productId") Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._toProductSubscriptionConfiguration(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Response patchProductByExternalReferenceCodeSubscriptionConfiguration(String externalReferenceCode, ProductSubscriptionConfiguration productSubscriptionConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        this._updateProductSubscriptionConfiguration(cpDefinition, productSubscriptionConfiguration);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdSubscriptionConfiguration(Long id, ProductSubscriptionConfiguration productSubscriptionConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        this._updateProductSubscriptionConfiguration(cpDefinition, productSubscriptionConfiguration);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    private ProductSubscriptionConfiguration _toProductSubscriptionConfiguration(Long cpDefinitionId) throws Exception {
        return (ProductSubscriptionConfiguration)this._productSubscriptionConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext((Object)cpDefinitionId, this.contextAcceptLanguage.getPreferredLocale()));
    }

    private ProductSubscriptionConfiguration _updateProductSubscriptionConfiguration(CPDefinition cpDefinition, ProductSubscriptionConfiguration productSubscriptionConfiguration) throws Exception {
        cpDefinition = ProductSubscriptionConfigurationUtil.updateCPDefinitionSubscriptionInfo(this._cpDefinitionService, productSubscriptionConfiguration, cpDefinition, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        return this._toProductSubscriptionConfiguration(cpDefinition.getCPDefinitionId());
    }
}

