/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPConfigurationListException;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.commerce.product.service.CommerceChannelRelService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationList;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListChannel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductConfigurationListChannelResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationListChannelResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-configuration-list-channel.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductConfigurationListChannelResource.class})
public class ProductConfigurationListChannelResourceImpl
extends BaseProductConfigurationListChannelResourceImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CommerceChannelRel)")
    private ModelResourcePermission<CommerceChannelRel> _commerceChannelRelModelResourcePermission;
    @Reference
    private CommerceChannelRelService _commerceChannelRelService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationListChannelDTOConverter)")
    private DTOConverter<CommerceChannelRel, ProductConfigurationListChannel> _productConfigurationListChannelDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteProductConfigurationListChannel(Long id) throws Exception {
        this._commerceChannelRelService.deleteCommerceChannelRel(id.longValue());
    }

    @Override
    public Page<ProductConfigurationListChannel> getProductConfigurationListByExternalReferenceCodeProductConfigurationListChannelsPage(String externalReferenceCode, Pagination pagination) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.fetchCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpConfigurationList == null) {
            throw new NoSuchCPConfigurationListException("Unable to find product configuration list channel with external reference code " + externalReferenceCode);
        }
        return this.getProductConfigurationListIdProductConfigurationListChannelsPage(cpConfigurationList.getCPConfigurationListId(), null, null, pagination, null);
    }

    @Override
    @NestedField(parentClass=ProductConfigurationList.class, value="productConfigurationListChannels")
    public Page<ProductConfigurationListChannel> getProductConfigurationListIdProductConfigurationListChannelsPage(Long id, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return Page.of(this._toProductConfigurationListChannels(this._commerceChannelRelService.getCommerceChannelRels(CPConfigurationList.class.getName(), id.longValue(), search, pagination.getStartPosition(), pagination.getEndPosition())), (Pagination)pagination, (long)this._commerceChannelRelService.getCommerceChannelRelsCount(CPConfigurationList.class.getName(), id.longValue(), search));
    }

    @Override
    public ProductConfigurationListChannel postProductConfigurationListByExternalReferenceCodeProductConfigurationListChannel(String externalReferenceCode, ProductConfigurationListChannel productConfigurationListChannel) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.fetchCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpConfigurationList == null) {
            throw new NoSuchCPConfigurationListException("Unable to find product configuration list channel with external reference code " + externalReferenceCode);
        }
        return this.postProductConfigurationListIdProductConfigurationListChannel(cpConfigurationList.getCPConfigurationListId(), productConfigurationListChannel);
    }

    @Override
    public ProductConfigurationListChannel postProductConfigurationListIdProductConfigurationListChannel(Long id, ProductConfigurationListChannel productConfigurationListChannel) throws Exception {
        CommerceChannelRel commerceChannelRel = this._addCommerceChannelRel(this._cpConfigurationListService.getCPConfigurationList(id.longValue()), productConfigurationListChannel);
        return this._toProductConfigurationListChannel(commerceChannelRel.getCommerceChannelRelId());
    }

    private CommerceChannelRel _addCommerceChannelRel(CPConfigurationList cpConfigurationList, ProductConfigurationListChannel productConfigurationListChannel) throws Exception {
        CommerceChannel commerceChannel = this._commerceChannelService.fetchCommerceChannelByExternalReferenceCode(GetterUtil.getString((String)productConfigurationListChannel.getChannelExternalReferenceCode()), cpConfigurationList.getCompanyId());
        if (commerceChannel == null) {
            commerceChannel = this._commerceChannelService.getCommerceChannel(productConfigurationListChannel.getChannelId().longValue());
        }
        return this._commerceChannelRelService.addCommerceChannelRel(CPConfigurationList.class.getName(), cpConfigurationList.getCPConfigurationListId(), commerceChannel.getCommerceChannelId(), this._serviceContextHelper.getServiceContext());
    }

    private Map<String, Map<String, String>> _getActions(long commerceChannelRelId) {
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", commerceChannelRelId, "deleteProductConfigurationListChannel", this._commerceChannelRelModelResourcePermission)).build();
    }

    private ProductConfigurationListChannel _toProductConfigurationListChannel(Long commerceChannelRelId) throws Exception {
        return (ProductConfigurationListChannel)this._productConfigurationListChannelDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(commerceChannelRelId), this._dtoConverterRegistry, (Object)commerceChannelRelId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private List<ProductConfigurationListChannel> _toProductConfigurationListChannels(List<CommerceChannelRel> commerceChannelRels) {
        return this.transform(commerceChannelRels, commerceChannelRel -> this._toProductConfigurationListChannel(commerceChannelRel.getCommerceChannelRelId()));
    }
}

