/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryLocalService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettingsFileEntry;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry"}, service={DTOConverter.class})
public class ProductVirtualSettingsFileEntryDTOConverter
implements DTOConverter<CPDVirtualSettingFileEntry, ProductVirtualSettingsFileEntry> {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPDefinitionVirtualSettingLocalService _cpDefinitionVirtualSettingLocalService;
    @Reference
    private CPDVirtualSettingFileEntryLocalService _cpdVirtualSettingFileEntryLocalService;

    public String getContentType() {
        return ProductVirtualSettingsFileEntry.class.getSimpleName();
    }

    public ProductVirtualSettingsFileEntry toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = this._cpdVirtualSettingFileEntryLocalService.getCPDVirtualSettingFileEntry(((Long)dtoConverterContext.getId()).longValue());
        return new ProductVirtualSettingsFileEntry(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setId(() -> ((CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntry).getCPDefinitionVirtualSettingFileEntryId());
                this.setSrc(() -> {
                    long fileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
                    if (fileEntryId == 0L) {
                        return null;
                    }
                    CPDefinitionVirtualSetting cpDefinitionVirtualSetting = ProductVirtualSettingsFileEntryDTOConverter.this._cpDefinitionVirtualSettingLocalService.getCPDefinitionVirtualSetting(cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingId());
                    return ProductVirtualSettingsFileEntryDTOConverter.this._commerceMediaResolver.getDownloadVirtualProductURL(CPDefinition.class.getName(), cpDefinitionVirtualSetting.getClassPK(), Long.MIN_VALUE, fileEntryId);
                });
                this.setUrl(() -> {
                    if (Validator.isBlank((String)cpdVirtualSettingFileEntry.getUrl())) {
                        return null;
                    }
                    return cpdVirtualSettingFileEntry.getUrl();
                });
                this.setVersion(() -> {
                    if (Validator.isBlank((String)cpdVirtualSettingFileEntry.getVersion())) {
                        return null;
                    }
                    return cpdVirtualSettingFileEntry.getVersion();
                });
            }
        };
    }
}

