/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListRel;
import com.liferay.commerce.product.service.CPConfigurationListRelService;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OrderType;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListOrderType;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.model.CPConfigurationListRel"}, service={DTOConverter.class})
public class ProductConfigurationListOrderTypeDTOConverter
implements DTOConverter<CPConfigurationListRel, ProductConfigurationListOrderType> {
    @Reference
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;
    @Reference
    private CPConfigurationListRelService _cpConfigurationListRelService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;

    public String getContentType() {
        return ProductConfigurationListOrderType.class.getSimpleName();
    }

    public ProductConfigurationListOrderType toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPConfigurationListRel cpConfigurationListRel = this._cpConfigurationListRelService.getCPConfigurationListRel(((Long)dtoConverterContext.getId()).longValue());
        final CommerceOrderType commerceOrderType = this._commerceOrderTypeLocalService.getCommerceOrderType(cpConfigurationListRel.getClassPK());
        final CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationList(cpConfigurationListRel.getCPConfigurationListId());
        return new ProductConfigurationListOrderType(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setOrderType(() -> new OrderType(){
                    {
                        this.setId(() -> ((CommerceOrderType)commerceOrderType).getCommerceOrderTypeId());
                        this.setName(() -> LanguageUtils.getLanguageIdMap((Map)commerceOrderType.getNameMap()));
                    }
                });
                this.setOrderTypeExternalReferenceCode(() -> ((CommerceOrderType)commerceOrderType).getExternalReferenceCode());
                this.setOrderTypeId(() -> ((CommerceOrderType)commerceOrderType).getCommerceOrderTypeId());
                this.setProductConfigurationListExternalReferenceCode(() -> ((CPConfigurationList)cpConfigurationList).getExternalReferenceCode());
                this.setProductConfigurationListId(() -> ((CPConfigurationList)cpConfigurationList).getCPConfigurationListId());
                this.setProductConfigurationListOrderTypeId(() -> ((CPConfigurationListRel)cpConfigurationListRel).getCPConfigurationListRelId());
            }
        };
    }
}

