/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPConfigurationEntry;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPConfigurationEntryService;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationList;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationDTOConverterContext;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.ProductConfigurationEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductConfigurationResource;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-configuration.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={ProductConfigurationResource.class})
public class ProductConfigurationResourceImpl
extends BaseProductConfigurationResourceImpl {
    private static final EntityModel _entityModel = new ProductConfigurationEntityModel();
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPConfigurationEntry)")
    private ModelResourcePermission<CPConfigurationEntry> _cpConfigurationEntryModelResourcePermission;
    @Reference
    private CPConfigurationEntryService _cpConfigurationEntryService;
    @Reference
    private CPConfigurationListService _cpConfigurationListService;
    @Reference
    private CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private Portal _portal;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationDTOConverter)")
    private DTOConverter<CPDefinitionInventory, ProductConfiguration> _productConfigurationDTOConverter;

    @Override
    public void deleteProductConfiguration(Long id) throws Exception {
        this._cpConfigurationEntryService.deleteCPConfigurationEntry(id.longValue());
    }

    @Override
    public void deleteProductConfigurationByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPConfigurationEntry cpConfigurationEntry = this._cpConfigurationEntryService.getCPConfigurationEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        this.deleteProductConfiguration(cpConfigurationEntry.getCPConfigurationEntryId());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public ProductConfiguration getProductByExternalReferenceCodeConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this.getProductIdConfiguration(cpDefinition.getCProductId());
    }

    @Override
    public ProductConfiguration getProductConfiguration(Long id) throws Exception {
        return this._toProductConfiguration(this._cpConfigurationEntryService.getCPConfigurationEntry(id.longValue()), false);
    }

    @Override
    public ProductConfiguration getProductConfigurationByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPConfigurationEntry cpConfigurationEntry = this._cpConfigurationEntryService.getCPConfigurationEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.getProductConfiguration(cpConfigurationEntry.getCPConfigurationEntryId());
    }

    @Override
    public Page<ProductConfiguration> getProductConfigurationListByExternalReferenceCodeProductConfigurationsPage(String externalReferenceCode, String search, Boolean showDifferences, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.getProductConfigurationListIdProductConfigurationsPage(cpConfigurationList.getCPConfigurationListId(), search, showDifferences, filter, pagination, sorts);
    }

    @Override
    @NestedField(parentClass=ProductConfigurationList.class, value="productConfigurations")
    public Page<ProductConfiguration> getProductConfigurationListIdProductConfigurationsPage(Long id, String search, Boolean showDifferences, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationList(id.longValue());
        long companyId = cpConfigurationList.getCompanyId();
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, (String)CPConfigurationEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"classPK"}), object -> {
            SearchUtil.SearchContext searchContext = object;
            searchContext.setAttribute("CPConfigurationListId", (Serializable)Long.valueOf(cpConfigurationList.getCPConfigurationListId()));
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(CPDefinition.class)));
            searchContext.setCompanyId(companyId);
        }, (Sort[])sorts, document -> this._toProductConfiguration(this._cpConfigurationEntryService.getCPConfigurationEntry(GetterUtil.getLong((String)document.get("classPK"))), GetterUtil.getBoolean((Object)showDifferences)));
    }

    @Override
    @NestedField(parentClass=Product.class, value="productConfiguration")
    public ProductConfiguration getProductIdConfiguration(@NestedFieldId(value="productId") Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        return this._toProductConfiguration(cpDefinition.getCPDefinitionId());
    }

    @Override
    public Response patchProductByExternalReferenceCodeConfiguration(String externalReferenceCode, ProductConfiguration productConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this.patchProductIdConfiguration(cpDefinition.getCProductId(), productConfiguration);
    }

    @Override
    public ProductConfiguration patchProductConfiguration(Long id, ProductConfiguration productConfiguration) throws Exception {
        CPConfigurationEntry cpConfigurationEntry = this._cpConfigurationEntryService.getCPConfigurationEntry(id.longValue());
        ProductShippingConfiguration productShippingConfiguration = this._getProductShippingConfiguration(productConfiguration);
        ProductTaxConfiguration productTaxConfiguration = this._getProductTaxConfiguration(productConfiguration);
        return this._toProductConfiguration(this._cpConfigurationEntryService.updateCPConfigurationEntry(GetterUtil.getString((String)productConfiguration.getExternalReferenceCode(), (String)cpConfigurationEntry.getExternalReferenceCode()), cpConfigurationEntry.getCPConfigurationEntryId(), GetterUtil.getLong((Object)productTaxConfiguration.getId(), (long)cpConfigurationEntry.getCPTaxCategoryId()), ProductConfigurationUtil.getAllowedOrderQuantities(productConfiguration.getAllowedOrderQuantities(), cpConfigurationEntry.getAllowedOrderQuantities()), GetterUtil.getBoolean((Object)productConfiguration.getAllowBackOrder(), (boolean)cpConfigurationEntry.isBackOrders()), GetterUtil.getLong((Object)productConfiguration.getAvailabilityEstimateId(), (long)cpConfigurationEntry.getCommerceAvailabilityEstimateId()), GetterUtil.getString((String)productConfiguration.getInventoryEngine(), (String)cpConfigurationEntry.getCPDefinitionInventoryEngine()), GetterUtil.getDouble((Object)productShippingConfiguration.getDepth(), (double)cpConfigurationEntry.getDepth()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayAvailability(), (boolean)cpConfigurationEntry.isDisplayAvailability()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayStockQuantity(), (boolean)cpConfigurationEntry.isDisplayStockQuantity()), GetterUtil.getBoolean((Object)productShippingConfiguration.getFreeShipping(), (boolean)cpConfigurationEntry.isFreeShipping()), GetterUtil.getDouble((Object)productShippingConfiguration.getHeight(), (double)cpConfigurationEntry.getHeight()), GetterUtil.getString((String)productConfiguration.getLowStockAction(), (String)cpConfigurationEntry.getLowStockActivity()), BigDecimalUtil.get((Object)productConfiguration.getMaxOrderQuantity(), (BigDecimal)cpConfigurationEntry.getMaxOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinOrderQuantity(), (BigDecimal)cpConfigurationEntry.getMinOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinStockQuantity(), (BigDecimal)cpConfigurationEntry.getMinStockQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMultipleOrderQuantity(), (BigDecimal)cpConfigurationEntry.getMultipleOrderQuantity()), GetterUtil.getBoolean((Object)productConfiguration.getPurchasable(), (boolean)cpConfigurationEntry.isPurchasable()), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippable(), (boolean)cpConfigurationEntry.isShippable()), GetterUtil.getDouble((Object)productShippingConfiguration.getShippingExtraPrice(), (double)cpConfigurationEntry.getShippingExtraPrice()), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippingSeparately(), (boolean)cpConfigurationEntry.isShipSeparately()), GetterUtil.getBoolean((Object)(!this._isTaxable(productTaxConfiguration) ? 1 : 0), (boolean)cpConfigurationEntry.isTaxExempt()), GetterUtil.getBoolean((Object)productConfiguration.getVisible(), (boolean)cpConfigurationEntry.isVisible()), GetterUtil.getDouble((Object)productShippingConfiguration.getWeight(), (double)cpConfigurationEntry.getWeight()), GetterUtil.getDouble((Object)productShippingConfiguration.getWidth(), (double)cpConfigurationEntry.getWidth())), false);
    }

    @Override
    public ProductConfiguration patchProductConfigurationByExternalReferenceCode(String externalReferenceCode, ProductConfiguration productConfiguration) throws Exception {
        CPConfigurationEntry cpConfigurationEntry = this._cpConfigurationEntryService.getCPConfigurationEntryByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.patchProductConfiguration(cpConfigurationEntry.getCPConfigurationEntryId(), productConfiguration);
    }

    @Override
    public Response patchProductIdConfiguration(Long id, ProductConfiguration productConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + id);
        }
        CPConfigurationEntry masterCPConfigurationEntry = cpDefinition.fetchMasterCPConfigurationEntry();
        if (masterCPConfigurationEntry != null) {
            ProductShippingConfiguration productShippingConfiguration = this._getProductShippingConfiguration(productConfiguration);
            ProductTaxConfiguration productTaxConfiguration = this._getProductTaxConfiguration(productConfiguration);
            this._cpConfigurationEntryService.updateCPConfigurationEntry(GetterUtil.getString((String)productConfiguration.getExternalReferenceCode(), (String)masterCPConfigurationEntry.getExternalReferenceCode()), masterCPConfigurationEntry.getCPConfigurationEntryId(), GetterUtil.getLong((Object)productTaxConfiguration.getId(), (long)masterCPConfigurationEntry.getCPTaxCategoryId()), ProductConfigurationUtil.getAllowedOrderQuantities(productConfiguration.getAllowedOrderQuantities(), masterCPConfigurationEntry.getAllowedOrderQuantities()), GetterUtil.getBoolean((Object)productConfiguration.getAllowBackOrder(), (boolean)masterCPConfigurationEntry.isBackOrders()), GetterUtil.getLong((Object)productConfiguration.getAvailabilityEstimateId(), (long)masterCPConfigurationEntry.getCommerceAvailabilityEstimateId()), GetterUtil.getString((String)productConfiguration.getInventoryEngine(), (String)masterCPConfigurationEntry.getCPDefinitionInventoryEngine()), GetterUtil.getDouble((Object)productShippingConfiguration.getDepth(), (double)masterCPConfigurationEntry.getDepth()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayAvailability(), (boolean)masterCPConfigurationEntry.isDisplayAvailability()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayStockQuantity(), (boolean)masterCPConfigurationEntry.isDisplayStockQuantity()), GetterUtil.getBoolean((Object)productShippingConfiguration.getFreeShipping(), (boolean)masterCPConfigurationEntry.isFreeShipping()), GetterUtil.getDouble((Object)productShippingConfiguration.getHeight(), (double)masterCPConfigurationEntry.getHeight()), GetterUtil.getString((String)productConfiguration.getLowStockAction(), (String)masterCPConfigurationEntry.getLowStockActivity()), BigDecimalUtil.get((Object)productConfiguration.getMaxOrderQuantity(), (BigDecimal)masterCPConfigurationEntry.getMaxOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinOrderQuantity(), (BigDecimal)masterCPConfigurationEntry.getMinOrderQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMinStockQuantity(), (BigDecimal)masterCPConfigurationEntry.getMinStockQuantity()), BigDecimalUtil.get((Object)productConfiguration.getMultipleOrderQuantity(), (BigDecimal)masterCPConfigurationEntry.getMultipleOrderQuantity()), GetterUtil.getBoolean((Object)productConfiguration.getPurchasable(), (boolean)masterCPConfigurationEntry.isPurchasable()), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippable(), (boolean)masterCPConfigurationEntry.isShippable()), GetterUtil.getDouble((Object)productShippingConfiguration.getShippingExtraPrice(), (double)masterCPConfigurationEntry.getShippingExtraPrice()), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippingSeparately(), (boolean)masterCPConfigurationEntry.isShipSeparately()), GetterUtil.getBoolean((Object)(!this._isTaxable(productTaxConfiguration) ? 1 : 0), (boolean)masterCPConfigurationEntry.isTaxExempt()), GetterUtil.getBoolean((Object)productConfiguration.getVisible(), (boolean)masterCPConfigurationEntry.isVisible()), GetterUtil.getDouble((Object)productShippingConfiguration.getWeight(), (double)masterCPConfigurationEntry.getWeight()), GetterUtil.getDouble((Object)productShippingConfiguration.getWidth(), (double)masterCPConfigurationEntry.getWidth()));
        }
        ProductConfigurationUtil.updateCPDefinitionInventory(this._cpDefinitionInventoryService, productConfiguration, cpDefinition.getCPDefinitionId());
        ProductConfigurationUtil.updateCPDAvailabilityEstimate(this._cpdAvailabilityEstimateService, productConfiguration, cpDefinition.getCPDefinitionId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public ProductConfiguration postProductConfigurationListByExternalReferenceCodeProductConfiguration(String externalReferenceCode, ProductConfiguration productConfiguration) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationListByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this.postProductConfigurationListIdProductConfiguration(cpConfigurationList.getCPConfigurationListId(), productConfiguration);
    }

    @Override
    public ProductConfiguration postProductConfigurationListIdProductConfiguration(Long id, ProductConfiguration productConfiguration) throws Exception {
        CPConfigurationList cpConfigurationList = this._cpConfigurationListService.getCPConfigurationList(id.longValue());
        long classNameId = this._portal.getClassNameId(CPDefinition.class.getName());
        long classPK = GetterUtil.getLong((Object)productConfiguration.getEntityId());
        ProductConfiguration.EntityType entityType = productConfiguration.getEntityType();
        if (entityType == null || Objects.equals(entityType.getValue(), "product")) {
            CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(GetterUtil.getString((String)productConfiguration.getEntityExternalReferenceCode()), this.contextCompany.getCompanyId());
            if (cpDefinition == null) {
                cpDefinition = this._cpDefinitionService.getCPDefinition(classPK);
            }
            classPK = cpDefinition.getCPDefinitionId();
        } else if (Objects.equals(entityType.getValue(), "template")) {
            classNameId = this._portal.getClassNameId(CPConfigurationList.class.getName());
            classPK = id;
        }
        ProductShippingConfiguration productShippingConfiguration = this._getProductShippingConfiguration(productConfiguration);
        ProductTaxConfiguration productTaxConfiguration = this._getProductTaxConfiguration(productConfiguration);
        return this._toProductConfiguration(this._cpConfigurationEntryService.addCPConfigurationEntry(GetterUtil.getString((String)productConfiguration.getExternalReferenceCode()), cpConfigurationList.getGroupId(), classNameId, classPK, id.longValue(), GetterUtil.getLong((Object)productTaxConfiguration.getId()), ProductConfigurationUtil.getAllowedOrderQuantities(productConfiguration.getAllowedOrderQuantities(), null), GetterUtil.getBoolean((Object)productConfiguration.getAllowBackOrder()), GetterUtil.getLong((Object)productConfiguration.getAvailabilityEstimateId()), GetterUtil.getString((String)productConfiguration.getInventoryEngine()), GetterUtil.getDouble((Object)productShippingConfiguration.getDepth()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayAvailability()), GetterUtil.getBoolean((Object)productConfiguration.getDisplayStockQuantity()), GetterUtil.getBoolean((Object)productShippingConfiguration.getFreeShipping(), (boolean)true), GetterUtil.getDouble((Object)productShippingConfiguration.getHeight()), GetterUtil.getString((String)productConfiguration.getLowStockAction()), BigDecimalUtil.get((Object)productConfiguration.getMaxOrderQuantity(), (BigDecimal)new BigDecimal(1000)), BigDecimalUtil.get((Object)productConfiguration.getMinOrderQuantity(), (BigDecimal)BigDecimal.ONE), BigDecimalUtil.get((Object)productConfiguration.getMinStockQuantity(), (BigDecimal)BigDecimal.ONE), BigDecimalUtil.get((Object)productConfiguration.getMultipleOrderQuantity(), (BigDecimal)BigDecimal.ONE), GetterUtil.getBoolean((Object)productConfiguration.getPurchasable(), (boolean)true), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippable(), (boolean)true), GetterUtil.getDouble((Object)productShippingConfiguration.getShippingExtraPrice()), GetterUtil.getBoolean((Object)productShippingConfiguration.getShippingSeparately(), (boolean)true), !GetterUtil.getBoolean((Object)productTaxConfiguration.getTaxable(), (boolean)true), GetterUtil.getBoolean((Object)productConfiguration.getVisible(), (boolean)true), GetterUtil.getDouble((Object)productShippingConfiguration.getWeight()), GetterUtil.getDouble((Object)productShippingConfiguration.getWidth())), false);
    }

    private Map<String, Map<String, String>> _getActions(CPConfigurationEntry cpConfigurationEntry) {
        return HashMapBuilder.put((Object)"delete", () -> this.addAction("UPDATE", cpConfigurationEntry.getCPConfigurationEntryId(), "deleteProductConfiguration", this._cpConfigurationEntryModelResourcePermission)).put((Object)"get", () -> this.addAction("VIEW", cpConfigurationEntry.getCPConfigurationEntryId(), "getProductConfiguration", this._cpConfigurationEntryModelResourcePermission)).put((Object)"update", () -> this.addAction("UPDATE", cpConfigurationEntry.getCPConfigurationEntryId(), "patchProductConfiguration", this._cpConfigurationEntryModelResourcePermission)).build();
    }

    private ProductShippingConfiguration _getProductShippingConfiguration(ProductConfiguration productConfiguration) {
        ProductShippingConfiguration productShippingConfiguration = productConfiguration.getProductShippingConfiguration();
        if (productShippingConfiguration == null) {
            return new ProductShippingConfiguration();
        }
        return productShippingConfiguration;
    }

    private ProductTaxConfiguration _getProductTaxConfiguration(ProductConfiguration productConfiguration) {
        ProductTaxConfiguration productTaxConfiguration = productConfiguration.getProductTaxConfiguration();
        if (productTaxConfiguration == null) {
            return new ProductTaxConfiguration();
        }
        return productTaxConfiguration;
    }

    private boolean _isTaxable(ProductTaxConfiguration productTaxConfiguration) {
        if (productTaxConfiguration.getTaxable() == null) {
            return true;
        }
        return productTaxConfiguration.getTaxable();
    }

    private ProductConfiguration _toProductConfiguration(CPConfigurationEntry cpConfigurationEntry, boolean showDifferences) throws Exception {
        return (ProductConfiguration)this._productConfigurationDTOConverter.toDTO((DTOConverterContext)new ProductConfigurationDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(cpConfigurationEntry), cpConfigurationEntry.getCPConfigurationEntryId(), this._dtoConverterRegistry, null, this.contextAcceptLanguage.getPreferredLocale(), showDifferences, this.contextUriInfo, this.contextUser));
    }

    private ProductConfiguration _toProductConfiguration(Long cpDefinitionId) throws Exception {
        return (ProductConfiguration)this._productConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this._dtoConverterRegistry, (Object)cpDefinitionId, this.contextAcceptLanguage.getPreferredLocale(), null, null));
    }
}

