/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.shop.by.diagram.model.CSDiagramEntry;
import com.liferay.commerce.shop.by.diagram.service.CSDiagramEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.MappedProduct;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseMappedProductResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.MappedProductUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.MappedProductResource;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/mapped-product.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={MappedProductResource.class})
public class MappedProductResourceImpl
extends BaseMappedProductResourceImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.product.model.CPDefinition)")
    private ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private CSDiagramEntryService _csDiagramEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(component.name=com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.MappedProductDTOConverter)")
    private DTOConverter<CSDiagramEntry, MappedProduct> _mappedProductDTOConverter;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public void deleteMappedProduct(Long mappedProductId) throws Exception {
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.getCSDiagramEntry(mappedProductId.longValue());
        this._csDiagramEntryService.deleteCSDiagramEntry(csDiagramEntry);
    }

    @Override
    public MappedProduct getProductByExternalReferenceCodeMappedProductBySequence(String externalReferenceCode, String sequence) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.fetchCSDiagramEntry(cpDefinition.getCPDefinitionId(), sequence);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    @Override
    public Page<MappedProduct> getProductByExternalReferenceCodeMappedProductsPage(String externalReferenceCode, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        return this._getMappedProductsPage(cpDefinition.getCPDefinitionId(), pagination, search, sorts);
    }

    @Override
    public MappedProduct getProductIdMappedProductBySequence(Long productId, String sequence) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.fetchCSDiagramEntry(cpDefinition.getCPDefinitionId(), sequence);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    @Override
    @NestedField(parentClass=Product.class, value="mappedProducts")
    public Page<MappedProduct> getProductIdMappedProductsPage(Long productId, String search, Pagination pagination, Sort[] sorts) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        return this._getMappedProductsPage(cpDefinition.getCPDefinitionId(), pagination, search, sorts);
    }

    @Override
    public MappedProduct patchMappedProduct(Long mappedProductId, MappedProduct mappedProduct) throws Exception {
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.getCSDiagramEntry(mappedProductId.longValue());
        CPDefinition cpDefinition = csDiagramEntry.getCPDefinition();
        MappedProductUtil.updateCSDiagramEntry(this.contextCompany.getCompanyId(), csDiagramEntry, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
        return this._toMappedProduct(mappedProductId);
    }

    @Override
    public MappedProduct postProductByExternalReferenceCodeMappedProduct(String externalReferenceCode, MappedProduct mappedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with external reference code " + externalReferenceCode);
        }
        CSDiagramEntry csDiagramEntry = MappedProductUtil.addCSDiagramEntry(this.contextCompany.getCompanyId(), cpDefinition.getCPDefinitionId(), this._cpDefinitionService, this._cpInstanceService, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    @Override
    public MappedProduct postProductIdMappedProduct(Long productId, MappedProduct mappedProduct) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(productId.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find product with ID " + productId);
        }
        CSDiagramEntry csDiagramEntry = MappedProductUtil.addCSDiagramEntry(this.contextCompany.getCompanyId(), cpDefinition.getCPDefinitionId(), this._cpDefinitionService, this._cpInstanceService, this._csDiagramEntryService, cpDefinition.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), mappedProduct, this._serviceContextHelper);
        return this._toMappedProduct(csDiagramEntry.getCSDiagramEntryId());
    }

    private Map<String, Map<String, String>> _getActions(long csDiagramEntryId) throws Exception {
        CSDiagramEntry csDiagramEntry = this._csDiagramEntryService.getCSDiagramEntry(csDiagramEntryId);
        return HashMapBuilder.put((Object)"delete", this.addAction("UPDATE", csDiagramEntry.getCPDefinitionId(), "deleteMappedProduct", this._cpDefinitionModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", csDiagramEntry.getCPDefinitionId(), "patchMappedProduct", this._cpDefinitionModelResourcePermission)).build();
    }

    private Page<MappedProduct> _getMappedProductsPage(long cpDefinitionId, Pagination pagination, String search, Sort[] sorts) throws Exception {
        return SearchUtil.search(null, booleanQuery -> {}, null, (String)CSDiagramEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
            searchContext.setAttribute("CPDefinitionId", (Serializable)Long.valueOf(cpDefinitionId));
        }, (Sort[])sorts, document -> this._toMappedProduct(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    private MappedProduct _toMappedProduct(long csDiagramEntryId) throws Exception {
        return (MappedProduct)this._mappedProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), this._getActions(csDiagramEntryId), this._dtoConverterRegistry, (Object)csDiagramEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

