/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=ProductShippingConfiguration"}, service={DTOConverter.class})
public class ProductShippingConfigurationDTOConverter
implements DTOConverter<CPDefinition, ProductShippingConfiguration> {
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return ProductShippingConfiguration.class.getSimpleName();
    }

    public ProductShippingConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
        return new ProductShippingConfiguration(){
            {
                this.setDepth(() -> BigDecimal.valueOf(cpDefinition.getDepth()));
                this.setFreeShipping(() -> ((CPDefinition)cpDefinition).isFreeShipping());
                this.setHeight(() -> BigDecimal.valueOf(cpDefinition.getHeight()));
                this.setShippable(() -> ((CPDefinition)cpDefinition).isShippable());
                this.setShippingExtraPrice(() -> BigDecimal.valueOf(cpDefinition.getShippingExtraPrice()));
                this.setShippingSeparately(() -> ((CPDefinition)cpDefinition).isShipSeparately());
                this.setWeight(() -> BigDecimal.valueOf(cpDefinition.getWeight()));
                this.setWidth(() -> BigDecimal.valueOf(cpDefinition.getWidth()));
            }
        };
    }
}

