/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.constants.CPDefinitionInventoryConstants;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.product.model.CPConfigurationEntry;
import com.liferay.commerce.product.model.CPConfigurationEntrySetting;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPConfigurationEntryService;
import com.liferay.commerce.product.service.CPConfigurationEntrySettingLocalService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CPDefinitionInventory"}, service={DTOConverter.class})
public class ProductConfigurationDTOConverter
implements DTOConverter<CPDefinitionInventory, ProductConfiguration> {
    private static final Log _log = LogFactoryUtil.getLog(ProductConfigurationDTOConverter.class);
    @Reference
    private CPConfigurationEntryService _cpConfigurationEntryService;
    @Reference
    private CPConfigurationEntrySettingLocalService _cpConfigurationEntrySettingLocalService;
    @Reference
    private CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private JSONFactory _jsonFactory;

    public String getContentType() {
        return ProductConfiguration.class.getSimpleName();
    }

    public ProductConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        ProductConfiguration productConfiguration = new ProductConfiguration();
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-10889")) {
            CPConfigurationEntry cpConfigurationEntry;
            if (dtoConverterContext.getId() != null) {
                CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
                cpConfigurationEntry = cpDefinition.fetchMasterCPConfigurationEntry();
            } else {
                ProductConfigurationDTOConverterContext productConfigurationDTOConverterContext = (ProductConfigurationDTOConverterContext)dtoConverterContext;
                cpConfigurationEntry = this._cpConfigurationEntryService.getCPConfigurationEntry(productConfigurationDTOConverterContext.getCPConfigurationEntryId());
            }
            if (cpConfigurationEntry == null) {
                return productConfiguration;
            }
            productConfiguration.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
            productConfiguration.setAllowBackOrder(() -> ((CPConfigurationEntry)cpConfigurationEntry).isBackOrders());
            productConfiguration.setAllowedOrderQuantities(() -> ((CPConfigurationEntry)cpConfigurationEntry).getAllowedOrderQuantitiesArray());
            productConfiguration.setDifferences(() -> this._getDifferences(cpConfigurationEntry, dtoConverterContext));
            productConfiguration.setEntityExternalReferenceCode(() -> this._getEntityExternalReferenceCode(cpConfigurationEntry));
            productConfiguration.setEntityId(() -> ((CPConfigurationEntry)cpConfigurationEntry).getClassPK());
            productConfiguration.setEntityName(() -> this._getEntityName(cpConfigurationEntry, dtoConverterContext.getLocale()));
            productConfiguration.setExternalReferenceCode(() -> ((CPConfigurationEntry)cpConfigurationEntry).getExternalReferenceCode());
            productConfiguration.setId(() -> ((CPConfigurationEntry)cpConfigurationEntry).getCPConfigurationEntryId());
            productConfiguration.setInventoryEngine(() -> ((CPConfigurationEntry)cpConfigurationEntry).getCPDefinitionInventoryEngine());
            productConfiguration.setLowStockAction(() -> ((CPConfigurationEntry)cpConfigurationEntry).getLowStockActivity());
            productConfiguration.setMaxOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMaxOrderQuantity()));
            productConfiguration.setMinOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMinOrderQuantity()));
            productConfiguration.setMinStockQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMinStockQuantity()));
            productConfiguration.setMultipleOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMultipleOrderQuantity()));
            productConfiguration.setProductShippingConfiguration(() -> {
                ProductShippingConfiguration productShippingConfiguration = new ProductShippingConfiguration();
                productShippingConfiguration.setDepth(() -> BigDecimal.valueOf(cpConfigurationEntry.getDepth()));
                productShippingConfiguration.setFreeShipping(() -> ((CPConfigurationEntry)cpConfigurationEntry).isFreeShipping());
                productShippingConfiguration.setHeight(() -> BigDecimal.valueOf(cpConfigurationEntry.getHeight()));
                productShippingConfiguration.setShippable(() -> ((CPConfigurationEntry)cpConfigurationEntry).isShippable());
                productShippingConfiguration.setShippingExtraPrice(() -> BigDecimal.valueOf(cpConfigurationEntry.getShippingExtraPrice()));
                productShippingConfiguration.setShippingSeparately(() -> ((CPConfigurationEntry)cpConfigurationEntry).isShipSeparately());
                productShippingConfiguration.setWeight(() -> BigDecimal.valueOf(cpConfigurationEntry.getWeight()));
                productShippingConfiguration.setWidth(() -> BigDecimal.valueOf(cpConfigurationEntry.getWidth()));
                return productShippingConfiguration;
            });
            productConfiguration.setProductTaxConfiguration(() -> {
                ProductTaxConfiguration productTaxConfiguration = new ProductTaxConfiguration();
                productTaxConfiguration.setId(() -> ((CPConfigurationEntry)cpConfigurationEntry).getCPTaxCategoryId());
                productTaxConfiguration.setTaxable(() -> !cpConfigurationEntry.isTaxExempt());
                productTaxConfiguration.setTaxCategory(() -> this._getTaxCategory(cpConfigurationEntry.getCPTaxCategory(), dtoConverterContext.getLocale()));
                return productTaxConfiguration;
            });
            productConfiguration.setPurchasable(() -> ((CPConfigurationEntry)cpConfigurationEntry).getPurchasable());
            productConfiguration.setVisible(() -> ((CPConfigurationEntry)cpConfigurationEntry).getVisible());
        } else {
            CPDAvailabilityEstimate cpdAvailabilityEstimate = this._cpdAvailabilityEstimateService.fetchCPDAvailabilityEstimateByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
            CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryService.fetchCPDefinitionInventoryByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
            if (cpdAvailabilityEstimate == null && cpDefinitionInventory == null) {
                return productConfiguration;
            }
            if (cpdAvailabilityEstimate != null) {
                productConfiguration.setAvailabilityEstimateId(() -> ((CPDAvailabilityEstimate)cpdAvailabilityEstimate).getCommerceAvailabilityEstimateId());
                productConfiguration.setAvailabilityEstimateName(() -> {
                    CommerceAvailabilityEstimate commerceAvailabilityEstimate = cpdAvailabilityEstimate.getCommerceAvailabilityEstimate();
                    if (commerceAvailabilityEstimate == null) {
                        return null;
                    }
                    return LanguageUtils.getLanguageIdMap((Map)commerceAvailabilityEstimate.getTitleMap());
                });
            }
            if (cpDefinitionInventory != null) {
                productConfiguration.setAllowBackOrder(() -> ((CPDefinitionInventory)cpDefinitionInventory).isBackOrders());
                productConfiguration.setAllowedOrderQuantities(() -> ((CPDefinitionInventory)cpDefinitionInventory).getAllowedOrderQuantitiesArray());
                productConfiguration.setInventoryEngine(() -> ((CPDefinitionInventory)cpDefinitionInventory).getCPDefinitionInventoryEngine());
                productConfiguration.setLowStockAction(() -> ((CPDefinitionInventory)cpDefinitionInventory).getLowStockActivity());
                productConfiguration.setMaxOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMaxOrderQuantity()));
                productConfiguration.setMinOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMinOrderQuantity()));
                productConfiguration.setMinStockQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMinStockQuantity()));
                productConfiguration.setMultipleOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMultipleOrderQuantity()));
            }
        }
        return productConfiguration;
    }

    private String[] _getDifferences(CPConfigurationEntry cpConfigurationEntry, DTOConverterContext dtoConverterContext) {
        ArrayList<String> differences;
        block28: {
            if (dtoConverterContext.getId() != null) {
                return null;
            }
            ProductConfigurationDTOConverterContext productConfigurationDTOConverterContext = (ProductConfigurationDTOConverterContext)dtoConverterContext;
            if (!productConfigurationDTOConverterContext.getShowDifferences()) {
                return null;
            }
            CPConfigurationEntrySetting cpConfigurationEntrySetting = this._cpConfigurationEntrySettingLocalService.fetchCPConfigurationEntrySetting(cpConfigurationEntry.getCPConfigurationEntryId(), 1);
            if (cpConfigurationEntrySetting == null) {
                return null;
            }
            differences = new ArrayList<String>();
            try {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(cpConfigurationEntrySetting.getValue());
                if (!Objects.equals(jsonObject.getString("allowedOrderQuantities"), cpConfigurationEntry.getAllowedOrderQuantities())) {
                    differences.add("allowedOrderQuantities");
                }
                if (jsonObject.getBoolean("backOrders", true) != cpConfigurationEntry.isBackOrders()) {
                    differences.add("backOrders");
                }
                if (jsonObject.getLong("commerceAvailabilityEstimateId") != cpConfigurationEntry.getCommerceAvailabilityEstimateId()) {
                    differences.add("commerceAvailabilityEstimateId");
                }
                if (!Objects.equals(jsonObject.getString("CPDefinitionInventoryEngine", "default"), cpConfigurationEntry.getCPDefinitionInventoryEngine())) {
                    differences.add("CPDefinitionInventoryEngine");
                }
                if (jsonObject.getLong("CPTaxCategoryId") != cpConfigurationEntry.getCPTaxCategoryId()) {
                    differences.add("CPTaxCategoryId");
                }
                if (jsonObject.getDouble("depth") != cpConfigurationEntry.getDepth()) {
                    differences.add("depth");
                }
                if (jsonObject.getBoolean("displayAvailability", false) != cpConfigurationEntry.isDisplayAvailability()) {
                    differences.add("displayAvailability");
                }
                if (jsonObject.getBoolean("displayStockQuantity", false) != cpConfigurationEntry.isDisplayStockQuantity()) {
                    differences.add("displayStockQuantity");
                }
                if (jsonObject.getBoolean("freeShipping", false) != cpConfigurationEntry.isFreeShipping()) {
                    differences.add("freeShipping");
                }
                if (jsonObject.getDouble("height") != cpConfigurationEntry.getHeight()) {
                    differences.add("height");
                }
                if (!Objects.equals(jsonObject.getString("lowStockActivity"), cpConfigurationEntry.getLowStockActivity())) {
                    differences.add("lowStockActivity");
                }
                if (!BigDecimalUtil.eq((BigDecimal)BigDecimal.valueOf(jsonObject.getDouble("maxOrderQuantity", CPDefinitionInventoryConstants.DEFAULT_MAX_ORDER_QUANTITY.doubleValue())), (BigDecimal)cpConfigurationEntry.getMaxOrderQuantity())) {
                    differences.add("maxOrderQuantity");
                }
                if (!BigDecimalUtil.eq((BigDecimal)BigDecimal.valueOf(jsonObject.getDouble("minOrderQuantity", CPDefinitionInventoryConstants.DEFAULT_MIN_ORDER_QUANTITY.doubleValue())), (BigDecimal)cpConfigurationEntry.getMinOrderQuantity())) {
                    differences.add("minOrderQuantity");
                }
                if (!BigDecimalUtil.eq((BigDecimal)BigDecimal.valueOf(jsonObject.getDouble("minStockQuantity")), (BigDecimal)cpConfigurationEntry.getMinStockQuantity())) {
                    differences.add("minStockQuantity");
                }
                if (!BigDecimalUtil.eq((BigDecimal)BigDecimal.valueOf(jsonObject.getDouble("multipleOrderQuantity", CPDefinitionInventoryConstants.DEFAULT_MULTIPLE_ORDER_QUANTITY.doubleValue())), (BigDecimal)cpConfigurationEntry.getMultipleOrderQuantity())) {
                    differences.add("multipleOrderQuantity");
                }
                if (jsonObject.getBoolean("purchasable", true) != cpConfigurationEntry.isPurchasable()) {
                    differences.add("purchasable");
                }
                if (jsonObject.getBoolean("shipSeparately", false) != cpConfigurationEntry.isShipSeparately()) {
                    differences.add("shipSeparately");
                }
                if (jsonObject.getBoolean("shippable", true) != cpConfigurationEntry.isShippable()) {
                    differences.add("shippable");
                }
                if (jsonObject.getDouble("shippingExtraPrice") != cpConfigurationEntry.getShippingExtraPrice()) {
                    differences.add("shippingExtraPrice");
                }
                if (jsonObject.getBoolean("taxExempt", false) != cpConfigurationEntry.isTaxExempt()) {
                    differences.add("taxExempt");
                }
                if (jsonObject.getBoolean("visible", true) != cpConfigurationEntry.isVisible()) {
                    differences.add("visible");
                }
                if (jsonObject.getDouble("weight") != cpConfigurationEntry.getWeight()) {
                    differences.add("weight");
                }
                if (jsonObject.getDouble("width") != cpConfigurationEntry.getWidth()) {
                    differences.add("width");
                }
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) break block28;
                _log.debug((Throwable)jsonException);
            }
        }
        return ArrayUtil.toStringArray(differences);
    }

    private String _getEntityExternalReferenceCode(CPConfigurationEntry cpConfigurationEntry) throws Exception {
        if (!StringUtil.equals((String)CPDefinition.class.getName(), (String)cpConfigurationEntry.getClassName())) {
            return null;
        }
        CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cpConfigurationEntry.getClassPK());
        CProduct cProduct = cpDefinition.getCProduct();
        return cProduct.getExternalReferenceCode();
    }

    private String _getEntityName(CPConfigurationEntry cpConfigurationEntry, Locale locale) throws PortalException {
        if (!StringUtil.equals((String)CPDefinition.class.getName(), (String)cpConfigurationEntry.getClassName())) {
            return null;
        }
        CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cpConfigurationEntry.getClassPK());
        return cpDefinition.getName(LocaleUtil.toLanguageId((Locale)locale));
    }

    private String _getTaxCategory(CPTaxCategory cpTaxCategory, Locale locale) {
        if (cpTaxCategory == null) {
            return null;
        }
        return cpTaxCategory.getName(locale);
    }
}

