/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListRel;
import com.liferay.commerce.product.service.CPConfigurationListRelService;
import com.liferay.commerce.product.service.CPConfigurationListService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfigurationListAccountGroup;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Danny Situ
 */
@Component(
	property = "dto.class.name=com.liferay.commerce.product.model.CPConfigurationListRel",
	service = DTOConverter.class
)
public class ProductConfigurationListAccountGroupDTOConverter
	implements DTOConverter
		<CPConfigurationListRel, ProductConfigurationListAccountGroup> {

	@Override
	public String getContentType() {
		return ProductConfigurationListAccountGroup.class.getSimpleName();
	}

	@Override
	public ProductConfigurationListAccountGroup toDTO(
			DTOConverterContext dtoConverterContext)
		throws Exception {

		CPConfigurationListRel cpConfigurationListRel =
			_cpConfigurationListRelService.getCPConfigurationListRel(
				(Long)dtoConverterContext.getId());

		CPConfigurationList cpConfigurationList =
			_cpConfigurationListService.getCPConfigurationList(
				cpConfigurationListRel.getCPConfigurationListId());
		AccountGroup cpConfigurationListAccountGroup =
			_accountGroupLocalService.getAccountGroup(
				cpConfigurationListRel.getClassPK());

		return new ProductConfigurationListAccountGroup() {
			{
				setAccountGroup(
					() ->
						new com.liferay.headless.commerce.admin.catalog.dto.
							v1_0.AccountGroup() {

							{
								setId(
									cpConfigurationListAccountGroup::
										getAccountGroupId);
								setName(
									cpConfigurationListAccountGroup::getName);
							}
						});
				setAccountGroupExternalReferenceCode(
					cpConfigurationListAccountGroup::getExternalReferenceCode);
				setAccountGroupId(
					cpConfigurationListAccountGroup::getAccountGroupId);
				setActions(dtoConverterContext::getActions);
				setProductConfigurationListAccountGroupId(
					cpConfigurationListRel::getCPConfigurationListRelId);
				setProductConfigurationListExternalReferenceCode(
					cpConfigurationList::getExternalReferenceCode);
				setProductConfigurationListId(
					cpConfigurationList::getCPConfigurationListId);
			}
		};
	}

	@Reference
	private AccountGroupLocalService _accountGroupLocalService;

	@Reference
	private CPConfigurationListRelService _cpConfigurationListRelService;

	@Reference
	private CPConfigurationListService _cpConfigurationListService;

}