/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.product.model.CPConfigurationEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPConfigurationEntryService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter.ProductConfigurationDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.math.BigDecimal;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.model.CPDefinitionInventory"}, service={DTOConverter.class})
public class ProductConfigurationDTOConverter
implements DTOConverter<CPDefinitionInventory, ProductConfiguration> {
    @Reference
    private CPConfigurationEntryService _cpConfigurationEntryService;
    @Reference
    private CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return ProductConfiguration.class.getSimpleName();
    }

    public ProductConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        ProductConfiguration productConfiguration = new ProductConfiguration();
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-10889")) {
            CPConfigurationEntry cpConfigurationEntry;
            if (dtoConverterContext.getId() != null) {
                CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(((Long)dtoConverterContext.getId()).longValue());
                cpConfigurationEntry = cpDefinition.fetchMasterCPConfigurationEntry();
            } else {
                ProductConfigurationDTOConverterContext productConfigurationDTOConverterContext = (ProductConfigurationDTOConverterContext)dtoConverterContext;
                cpConfigurationEntry = this._cpConfigurationEntryService.getCPConfigurationEntry(productConfigurationDTOConverterContext.getCPConfigurationEntryId());
            }
            if (cpConfigurationEntry == null) {
                return productConfiguration;
            }
            productConfiguration.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
            productConfiguration.setAllowBackOrder(() -> ((CPConfigurationEntry)cpConfigurationEntry).isBackOrders());
            productConfiguration.setAllowedOrderQuantities(() -> ((CPConfigurationEntry)cpConfigurationEntry).getAllowedOrderQuantitiesArray());
            productConfiguration.setEntityExternalReferenceCode(() -> this._getEntityExternalReferenceCode(cpConfigurationEntry));
            productConfiguration.setEntityId(() -> ((CPConfigurationEntry)cpConfigurationEntry).getClassPK());
            productConfiguration.setExternalReferenceCode(() -> ((CPConfigurationEntry)cpConfigurationEntry).getExternalReferenceCode());
            productConfiguration.setId(() -> ((CPConfigurationEntry)cpConfigurationEntry).getCPConfigurationEntryId());
            productConfiguration.setInventoryEngine(() -> ((CPConfigurationEntry)cpConfigurationEntry).getCPDefinitionInventoryEngine());
            productConfiguration.setLowStockAction(() -> ((CPConfigurationEntry)cpConfigurationEntry).getLowStockActivity());
            productConfiguration.setMaxOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMaxOrderQuantity()));
            productConfiguration.setMinOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMinOrderQuantity()));
            productConfiguration.setMinStockQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMinStockQuantity()));
            productConfiguration.setMultipleOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpConfigurationEntry.getMultipleOrderQuantity()));
        } else {
            CPDAvailabilityEstimate cpdAvailabilityEstimate = this._cpdAvailabilityEstimateService.fetchCPDAvailabilityEstimateByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
            CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryService.fetchCPDefinitionInventoryByCPDefinitionId(((Long)dtoConverterContext.getId()).longValue());
            if (cpdAvailabilityEstimate == null && cpDefinitionInventory == null) {
                return productConfiguration;
            }
            if (cpdAvailabilityEstimate != null) {
                productConfiguration.setAvailabilityEstimateId(() -> ((CPDAvailabilityEstimate)cpdAvailabilityEstimate).getCommerceAvailabilityEstimateId());
                productConfiguration.setAvailabilityEstimateName(() -> {
                    CommerceAvailabilityEstimate commerceAvailabilityEstimate = cpdAvailabilityEstimate.getCommerceAvailabilityEstimate();
                    if (commerceAvailabilityEstimate == null) {
                        return null;
                    }
                    return LanguageUtils.getLanguageIdMap((Map)commerceAvailabilityEstimate.getTitleMap());
                });
            }
            if (cpDefinitionInventory != null) {
                productConfiguration.setAllowBackOrder(() -> ((CPDefinitionInventory)cpDefinitionInventory).isBackOrders());
                productConfiguration.setAllowedOrderQuantities(() -> ((CPDefinitionInventory)cpDefinitionInventory).getAllowedOrderQuantitiesArray());
                productConfiguration.setInventoryEngine(() -> ((CPDefinitionInventory)cpDefinitionInventory).getCPDefinitionInventoryEngine());
                productConfiguration.setLowStockAction(() -> ((CPDefinitionInventory)cpDefinitionInventory).getLowStockActivity());
                productConfiguration.setMaxOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMaxOrderQuantity()));
                productConfiguration.setMinOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMinOrderQuantity()));
                productConfiguration.setMinStockQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMinStockQuantity()));
                productConfiguration.setMultipleOrderQuantity(() -> BigDecimalUtil.stripTrailingZeros((BigDecimal)cpDefinitionInventory.getMultipleOrderQuantity()));
            }
        }
        return productConfiguration;
    }

    private String _getEntityExternalReferenceCode(CPConfigurationEntry cpConfigurationEntry) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cpConfigurationEntry.getClassPK());
        CProduct cProduct = cpDefinition.getCProduct();
        return cProduct.getExternalReferenceCode();
    }
}

