/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.type.virtual.constants.VirtualCPTypeConstants;
import com.liferay.commerce.product.type.virtual.model.CPDVirtualSettingFileEntry;
import com.liferay.commerce.product.type.virtual.model.CPDefinitionVirtualSetting;
import com.liferay.commerce.product.type.virtual.service.CPDVirtualSettingFileEntryService;
import com.liferay.commerce.product.type.virtual.service.CPDefinitionVirtualSettingService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettings;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductVirtualSettingsFileEntry;
import com.liferay.headless.commerce.admin.catalog.internal.util.FileEntryUtil;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ProductVirtualSettingsUtil {
    public static CPDefinitionVirtualSetting addOrUpdateProductVirtualSettings(CPDefinition cpDefinition, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.fetchCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        if (cpDefinitionVirtualSetting == null) {
            return ProductVirtualSettingsUtil._addProductVirtualSettings(cpDefinition, productVirtualSettings, cpDefinitionVirtualSettingService, cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
        }
        return ProductVirtualSettingsUtil._updateProductVirtualSettings(cpDefinition, cpDefinitionVirtualSetting, productVirtualSettings, cpDefinitionVirtualSettingService, cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
    }

    private static CPDefinitionVirtualSetting _addProductVirtualSettings(CPDefinition cpDefinition, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        String attachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getUrl());
        long attachmentFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getAttachment(), attachmentURL, cpDefinition.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
        String sampleAttachmentURL = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)productVirtualSettings.getUseSample());
        if (useSample) {
            sampleAttachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getSampleURL());
            sampleFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getSampleAttachment(), sampleAttachmentURL, cpDefinition.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.getBoolean((Object)productVirtualSettings.getTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)productVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)productVirtualSettings.getTermsOfUseJournalArticleId());
        }
        CPDefinitionVirtualSetting cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.addCPDefinitionVirtualSetting(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), attachmentFileEntryId, attachmentURL, ProductVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)productVirtualSettings.getActivationStatus(), (int)0)), TimeUnit.DAYS.toMillis(GetterUtil.getLong((Object)productVirtualSettings.getDuration())), GetterUtil.getInteger((Object)productVirtualSettings.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentURL, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, false, serviceContext);
        if (productVirtualSettings.getProductVirtualSettingsFileEntries() == null) {
            return cpDefinitionVirtualSetting;
        }
        for (ProductVirtualSettingsFileEntry productVirtualSettingsFileEntry : productVirtualSettings.getProductVirtualSettingsFileEntries()) {
            cpdVirtualSettingFileEntryService.addCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getGroupId(), CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), FileEntryUtil.getFileEntryId(productVirtualSettingsFileEntry.getAttachment(), productVirtualSettingsFileEntry.getUrl(), cpDefinition.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext), productVirtualSettingsFileEntry.getUrl(), productVirtualSettingsFileEntry.getVersion());
        }
        return cpDefinitionVirtualSetting;
    }

    private static int _getActivationStatus(int activationStatus) {
        if (ArrayUtil.contains((int[])VirtualCPTypeConstants.ACTIVATION_STATUSES, (int)activationStatus)) {
            return activationStatus;
        }
        return 0;
    }

    private static CPDefinitionVirtualSetting _updateProductVirtualSettings(CPDefinition cpDefinition, CPDefinitionVirtualSetting cpDefinitionVirtualSetting, ProductVirtualSettings productVirtualSettings, CPDefinitionVirtualSettingService cpDefinitionVirtualSettingService, CPDVirtualSettingFileEntryService cpdVirtualSettingFileEntryService, DLAppService dlAppService, RepositoryLocalService repositoryLocalService, UniqueFileNameProvider uniqueFileNameProvider, ServiceContext serviceContext) throws Exception {
        Long duration;
        long attachmentFileEntryId = 0L;
        String attachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getUrl());
        if (Validator.isNull((String)attachmentURL)) {
            List cpdVirtualSettingFileEntries = cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries();
            CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry = (CPDVirtualSettingFileEntry)cpdVirtualSettingFileEntries.get(0);
            if (Validator.isNull((String)productVirtualSettings.getAttachment())) {
                attachmentURL = cpdVirtualSettingFileEntry.getUrl();
            } else {
                attachmentFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getAttachment(), attachmentURL, cpDefinition.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
            }
            if (attachmentFileEntryId == 0L) {
                attachmentFileEntryId = cpdVirtualSettingFileEntry.getFileEntryId();
            }
        }
        if ((duration = productVirtualSettings.getDuration()) != null) {
            duration = TimeUnit.DAYS.toMillis(duration);
        }
        String sampleAttachmentURL = null;
        long sampleFileEntryId = 0L;
        boolean useSample = GetterUtil.getBoolean((Object)productVirtualSettings.getUseSample(), (boolean)cpDefinitionVirtualSetting.isUseSample());
        if (useSample && Validator.isNull((String)(sampleAttachmentURL = ProductVirtualSettingsUtil._validateURL(productVirtualSettings.getSampleURL())))) {
            if (Validator.isNull((String)productVirtualSettings.getSampleAttachment())) {
                sampleAttachmentURL = cpDefinitionVirtualSetting.getSampleURL();
            } else {
                sampleFileEntryId = FileEntryUtil.getFileEntryId(productVirtualSettings.getSampleAttachment(), sampleAttachmentURL, cpDefinition.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext);
            }
            if (sampleFileEntryId == 0L) {
                sampleFileEntryId = cpDefinitionVirtualSetting.getSampleFileEntryId();
            }
        }
        Map termsOfUseContentMap = null;
        long termsOfUseJournalArticleId = 0L;
        boolean termsOfUseRequired = GetterUtil.get((Object)productVirtualSettings.getTermsOfUseRequired(), (boolean)cpDefinitionVirtualSetting.isTermsOfUseRequired());
        if (termsOfUseRequired) {
            termsOfUseContentMap = LanguageUtils.getLocalizedMap((Map)productVirtualSettings.getTermsOfUseContent());
            termsOfUseJournalArticleId = GetterUtil.getLong((Object)productVirtualSettings.getTermsOfUseJournalArticleId());
            if (termsOfUseContentMap == null && termsOfUseJournalArticleId == 0L) {
                JournalArticle termsOfUseJournalArticle = cpDefinitionVirtualSetting.getTermsOfUseJournalArticle();
                if (termsOfUseJournalArticle != null) {
                    termsOfUseJournalArticleId = termsOfUseJournalArticle.getResourcePrimKey();
                } else {
                    termsOfUseContentMap = cpDefinitionVirtualSetting.getTermsOfUseContentMap();
                }
            }
        }
        cpDefinitionVirtualSetting = cpDefinitionVirtualSettingService.updateCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), attachmentFileEntryId, attachmentURL, ProductVirtualSettingsUtil._getActivationStatus(GetterUtil.getInteger((Object)productVirtualSettings.getActivationStatus(), (int)cpDefinitionVirtualSetting.getActivationStatus())), GetterUtil.getLong((Object)duration, (long)cpDefinitionVirtualSetting.getDuration()), GetterUtil.getInteger((Object)productVirtualSettings.getMaxUsages(), (int)cpDefinitionVirtualSetting.getMaxUsages()), useSample, sampleFileEntryId, sampleAttachmentURL, termsOfUseRequired, termsOfUseContentMap, termsOfUseJournalArticleId, serviceContext);
        if (productVirtualSettings.getProductVirtualSettingsFileEntries() == null) {
            return cpDefinitionVirtualSetting;
        }
        for (CPDVirtualSettingFileEntry cpdVirtualSettingFileEntry : cpDefinitionVirtualSetting.getCPDVirtualSettingFileEntries()) {
            cpdVirtualSettingFileEntryService.deleteCPDVirtualSettingFileEntry(CPDefinition.class.getName(), cpDefinitionVirtualSetting.getClassPK(), cpdVirtualSettingFileEntry.getCPDefinitionVirtualSettingFileEntryId());
        }
        for (ProductVirtualSettingsFileEntry productVirtualSettingsFileEntry : productVirtualSettings.getProductVirtualSettingsFileEntries()) {
            cpdVirtualSettingFileEntryService.addCPDefinitionVirtualSetting(cpDefinitionVirtualSetting.getGroupId(), CPDefinition.class.getName(), cpDefinitionVirtualSetting.getClassPK(), cpDefinitionVirtualSetting.getCPDefinitionVirtualSettingId(), FileEntryUtil.getFileEntryId(productVirtualSettingsFileEntry.getAttachment(), productVirtualSettingsFileEntry.getUrl(), cpDefinition.getGroupId(), cpdVirtualSettingFileEntryService, dlAppService, repositoryLocalService, uniqueFileNameProvider, serviceContext), productVirtualSettingsFileEntry.getUrl(), productVirtualSettingsFileEntry.getVersion());
        }
        return cpDefinitionVirtualSetting;
    }

    private static String _validateURL(String value) throws Exception {
        if (Validator.isNotNull((String)value)) {
            URL url = new URL(value);
            return url.toString();
        }
        return null;
    }
}

