/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.type.grouped.model.CPDefinitionGroupedEntry;
import com.liferay.commerce.product.type.grouped.service.CPDefinitionGroupedEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.GroupedProduct;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.commerce.product.type.grouped.model.CPDefinitionGroupedEntry"}, service={DTOConverter.class})
public class GroupedProductDTOConverter
implements DTOConverter<CPDefinitionGroupedEntry, GroupedProduct> {
    @Reference
    private CPDefinitionGroupedEntryService _cpDefinitionGroupedEntryService;
    @Reference
    private CPDefinitionService _cpDefinitionService;

    public String getContentType() {
        return GroupedProduct.class.getSimpleName();
    }

    public GroupedProduct toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionGroupedEntry cpDefinitionGroupedEntry = this._cpDefinitionGroupedEntryService.getCPDefinitionGroupedEntry(((Long)dtoConverterContext.getId()).longValue());
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(cpDefinitionGroupedEntry.getCPDefinitionId());
        final CProduct cProduct = cpDefinition.getCProduct();
        final CPDefinition entryCPDefinition = this._cpDefinitionService.getCPDefinition(cpDefinitionGroupedEntry.getEntryCPDefinitionId());
        final CProduct entryCProduct = entryCPDefinition.getCProduct();
        return new GroupedProduct(){
            {
                this.setEntryProductExternalReferenceCode(() -> ((CProduct)entryCProduct).getExternalReferenceCode());
                this.setEntryProductId(() -> ((CProduct)entryCProduct).getCProductId());
                this.setEntryProductName(() -> LanguageUtils.getLanguageIdMap((Map)entryCPDefinition.getNameMap()));
                this.setId(() -> ((CPDefinitionGroupedEntry)cpDefinitionGroupedEntry).getCPDefinitionGroupedEntryId());
                this.setPriority(() -> ((CPDefinitionGroupedEntry)cpDefinitionGroupedEntry).getPriority());
                this.setProductExternalReferenceCode(() -> ((CProduct)cProduct).getExternalReferenceCode());
                this.setProductId(() -> ((CProduct)cProduct).getCProductId());
                this.setProductName(() -> LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap()));
                this.setQuantity(() -> ((CPDefinitionGroupedEntry)cpDefinitionGroupedEntry).getQuantity());
            }
        };
    }
}

