/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={DTOConverter.class})
public class CategoryDTOConverter
implements DTOConverter<AssetCategory, Category> {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;

    public String getContentType() {
        return Category.class.getSimpleName();
    }

    public Category toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final AssetCategory assetCategory = this._assetCategoryService.getCategory(((Long)dtoConverterContext.getId()).longValue());
        return new Category(){
            {
                this.setExternalReferenceCode(() -> ((AssetCategory)assetCategory).getExternalReferenceCode());
                this.setId(() -> ((AssetCategory)assetCategory).getCategoryId());
                this.setName(() -> ((AssetCategory)assetCategory).getName());
                this.setSiteId(() -> ((AssetCategory)assetCategory).getGroupId());
                this.setTitle(() -> LanguageUtils.getLanguageIdMap((Map)assetCategory.getTitleMap()));
                this.setVocabulary(() -> {
                    AssetVocabulary assetVocabulary = CategoryDTOConverter.this._assetVocabularyLocalService.getAssetVocabulary(assetCategory.getVocabularyId());
                    return assetVocabulary.getName();
                });
            }
        };
    }
}

